/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OsStats
implements Streamable,
Serializable,
ToXContent {
    public static final double[] EMPTY_LOAD = new double[0];
    long timestamp;
    double[] loadAverage = EMPTY_LOAD;
    long uptime = -1L;
    Cpu cpu = null;
    Mem mem = null;
    Swap swap = null;

    OsStats() {
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    public double[] loadAverage() {
        return this.loadAverage;
    }

    public double[] getLoadAverage() {
        return this.loadAverage();
    }

    public TimeValue uptime() {
        return new TimeValue(this.uptime, TimeUnit.SECONDS);
    }

    public TimeValue getUptime() {
        return this.uptime();
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Swap swap() {
        return this.swap;
    }

    public Swap getSwap() {
        return this.swap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("os");
        builder.field("timestamp", this.timestamp);
        builder.field("uptime", this.uptime().format());
        builder.field("uptime_in_millis", this.uptime().millis());
        builder.startArray("load_average");
        for (double value : this.loadAverage) {
            builder.value(value);
        }
        builder.endArray();
        if (this.cpu != null) {
            builder.startObject("cpu");
            builder.field("sys", (int)this.cpu.sys());
            builder.field("user", (int)this.cpu.user());
            builder.field("idle", (int)this.cpu.idle());
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject("mem");
            builder.field("free", this.mem.free().toString());
            builder.field("free_in_bytes", this.mem.free().bytes());
            builder.field("used", this.mem.used().toString());
            builder.field("used_in_bytes", this.mem.used().bytes());
            builder.field("free_percent", (int)this.mem.freePercent());
            builder.field("used_percent", (int)this.mem.usedPercent());
            builder.field("actual_free", this.mem.actualFree().toString());
            builder.field("actual_free_in_bytes", this.mem.actualFree().bytes());
            builder.field("actual_used", this.mem.actualUsed().toString());
            builder.field("actual_used_in_bytes", this.mem.actualUsed().bytes());
            builder.endObject();
        }
        if (this.swap != null) {
            builder.startObject("swap");
            builder.field("used", this.swap.used().toString());
            builder.field("used_in_bytes", this.swap.used().bytes());
            builder.field("free", this.swap.free().toString());
            builder.field("free_in_bytes", this.swap.free().bytes());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static OsStats readOsStats(StreamInput in) throws IOException {
        OsStats stats = new OsStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.loadAverage = new double[in.readVInt()];
        for (int i = 0; i < this.loadAverage.length; ++i) {
            this.loadAverage[i] = in.readDouble();
        }
        this.uptime = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.swap = Swap.readSwap(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVInt(this.loadAverage.length);
        for (double val : this.loadAverage) {
            out.writeDouble(val);
        }
        out.writeLong(this.uptime);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.swap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.swap.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        short sys = (short)-1;
        short user = (short)-1;
        short idle = (short)-1;

        Cpu() {
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.sys = in.readShort();
            this.user = in.readShort();
            this.idle = in.readShort();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.sys);
            out.writeShort(this.user);
            out.writeShort(this.idle);
        }

        public short sys() {
            return this.sys;
        }

        public short getSys() {
            return this.sys();
        }

        public short user() {
            return this.user;
        }

        public short getUser() {
            return this.user();
        }

        public short idle() {
            return this.idle;
        }

        public short getIdle() {
            return this.idle();
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long free = -1L;
        short freePercent = (short)-1;
        long used = -1L;
        short usedPercent = (short)-1;
        long actualFree = -1L;
        long actualUsed = -1L;

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.free = in.readLong();
            this.freePercent = in.readShort();
            this.used = in.readLong();
            this.usedPercent = in.readShort();
            this.actualFree = in.readLong();
            this.actualUsed = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.free);
            out.writeShort(this.freePercent);
            out.writeLong(this.used);
            out.writeShort(this.usedPercent);
            out.writeLong(this.actualFree);
            out.writeLong(this.actualUsed);
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        public short usedPercent() {
            return this.usedPercent;
        }

        public short getUsedPercent() {
            return this.usedPercent();
        }

        public ByteSizeValue free() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getFree() {
            return this.free();
        }

        public short freePercent() {
            return this.freePercent;
        }

        public short getFreePercent() {
            return this.freePercent();
        }

        public ByteSizeValue actualFree() {
            return new ByteSizeValue(this.actualFree);
        }

        public ByteSizeValue getActualFree() {
            return this.actualFree();
        }

        public ByteSizeValue actualUsed() {
            return new ByteSizeValue(this.actualUsed);
        }

        public ByteSizeValue getActualUsed() {
            return this.actualUsed();
        }
    }

    public static class Swap
    implements Streamable,
    Serializable {
        long free = -1L;
        long used = -1L;

        public ByteSizeValue free() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getFree() {
            return this.free();
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        public static Swap readSwap(StreamInput in) throws IOException {
            Swap swap = new Swap();
            swap.readFrom(in);
            return swap;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.free = in.readLong();
            this.used = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.free);
            out.writeLong(this.used);
        }
    }
}

