/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OsInfo
implements Streamable,
Serializable,
ToXContent {
    long refreshInterval;
    Cpu cpu = null;
    Mem mem = null;
    Swap swap = null;

    OsInfo() {
    }

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Swap swap() {
        return this.swap;
    }

    public Swap getSwap() {
        return this.swap();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("os");
        builder.field("refresh_interval", this.refreshInterval);
        if (this.cpu != null) {
            builder.startObject("cpu");
            builder.field("vendor", this.cpu.vendor());
            builder.field("model", this.cpu.model());
            builder.field("mhz", this.cpu.mhz());
            builder.field("total_cores", this.cpu.totalCores());
            builder.field("total_sockets", this.cpu.totalSockets());
            builder.field("cores_per_socket", this.cpu.coresPerSocket());
            builder.field("cache_size", this.cpu.cacheSize().toString());
            builder.field("cache_size_in_bytes", this.cpu.cacheSize().bytes());
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject("mem");
            builder.field("total", this.mem.total().toString());
            builder.field("total_in_bytes", this.mem.total().bytes());
            builder.endObject();
        }
        if (this.swap != null) {
            builder.startObject("swap");
            builder.field("total", this.swap.total().toString());
            builder.field("total_in_bytes", this.swap.total().bytes());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static OsInfo readOsInfo(StreamInput in) throws IOException {
        OsInfo info = new OsInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.swap = Swap.readSwap(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.swap == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.swap.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        String vendor = "";
        String model = "";
        int mhz = -1;
        int totalCores = -1;
        int totalSockets = -1;
        int coresPerSocket = -1;
        long cacheSize = -1L;

        Cpu() {
        }

        public String vendor() {
            return this.vendor;
        }

        public String getVendor() {
            return this.vendor();
        }

        public String model() {
            return this.model;
        }

        public String getModel() {
            return this.model;
        }

        public int mhz() {
            return this.mhz;
        }

        public int getMhz() {
            return this.mhz;
        }

        public int totalCores() {
            return this.totalCores;
        }

        public int getTotalCores() {
            return this.totalCores();
        }

        public int totalSockets() {
            return this.totalSockets;
        }

        public int getTotalSockets() {
            return this.totalSockets();
        }

        public int coresPerSocket() {
            return this.coresPerSocket;
        }

        public int getCoresPerSocket() {
            return this.coresPerSocket();
        }

        public ByteSizeValue cacheSize() {
            return new ByteSizeValue(this.cacheSize);
        }

        public ByteSizeValue getCacheSize() {
            return this.cacheSize();
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.vendor = in.readUTF();
            this.model = in.readUTF();
            this.mhz = in.readInt();
            this.totalCores = in.readInt();
            this.totalSockets = in.readInt();
            this.coresPerSocket = in.readInt();
            this.cacheSize = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.vendor);
            out.writeUTF(this.model);
            out.writeInt(this.mhz);
            out.writeInt(this.totalCores);
            out.writeInt(this.totalSockets);
            out.writeInt(this.coresPerSocket);
            out.writeLong(this.cacheSize);
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long total = -1L;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
        }

        public ByteSizeValue total() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getTotal() {
            return this.total();
        }
    }

    public static class Swap
    implements Streamable,
    Serializable {
        long total = -1L;

        Swap() {
        }

        public static Swap readSwap(StreamInput in) throws IOException {
            Swap swap = new Swap();
            swap.readFrom(in);
            return swap;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
        }

        public ByteSizeValue total() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getTotal() {
            return this.total();
        }
    }
}

