/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.matcher.Matchers;
import org.elasticsearch.common.inject.spi.InjectionListener;
import org.elasticsearch.common.inject.spi.TypeEncounter;
import org.elasticsearch.common.inject.spi.TypeListener;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.action.GetJmxServiceUrlAction;

public class JmxModule
extends AbstractModule {
    private final Settings settings;

    public JmxModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        JmxService jmxService = new JmxService(Loggers.getLogger(JmxService.class, this.settings.get("name")), this.settings);
        this.bind(JmxService.class).toInstance(jmxService);
        this.bind(GetJmxServiceUrlAction.class).asEagerSingleton();
        this.bindListener(Matchers.any(), new JmxExporterTypeListener(jmxService));
    }

    private static class JmxExporterInjectionListener<I>
    implements InjectionListener<I> {
        private final JmxService jmxService;

        private JmxExporterInjectionListener(JmxService jmxService) {
            this.jmxService = jmxService;
        }

        @Override
        public void afterInjection(I instance) {
            this.jmxService.registerMBean(instance);
        }
    }

    private static class JmxExporterTypeListener
    implements TypeListener {
        private final JmxService jmxService;

        private JmxExporterTypeListener(JmxService jmxService) {
            this.jmxService = jmxService;
        }

        @Override
        public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
            Class<I> type = typeLiteral.getRawType();
            if (type.isAnnotationPresent(MBean.class)) {
                typeEncounter.register(new JmxExporterInjectionListener(this.jmxService));
            }
        }
    }
}

