/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.memory;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.support.AbstractStore;

public class ByteBufferStore
extends AbstractStore {
    private final Directory directory;

    @Inject
    public ByteBufferStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, ByteBufferCache byteBufferCache) throws IOException {
        super(shardId, indexSettings, indexStore);
        this.directory = this.wrapDirectory(new ByteBufferDirectory(byteBufferCache));
        this.logger.debug("Using [byte_buffer] store", new Object[0]);
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public boolean suggestUseCompoundFile() {
        return false;
    }
}

