/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.settings.IndexSettings;

public class TermFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "term";

    @Inject
    public TermFilterParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = true;
        String fieldName = null;
        String value = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            fieldName = currentFieldName;
            value = parser.text();
        }
        if (fieldName == null) {
            throw new QueryParsingException(this.index, "No field specified for term filter");
        }
        if (value == null) {
            throw new QueryParsingException(this.index, "No value specified for term filter");
        }
        Filter filter = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            filter = smartNameFieldMappers.mapper().fieldFilter(value);
        }
        if (filter == null) {
            filter = new TermFilter(new Term(fieldName, value));
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

