/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class UidFieldMapper
extends AbstractFieldMapper<Uid>
implements org.elasticsearch.index.mapper.UidFieldMapper {
    public static final String CONTENT_TYPE = "_uid";
    private ThreadLocal<UidField> fieldCache = new ThreadLocal<UidField>(){

        @Override
        protected UidField initialValue() {
            return new UidField(UidFieldMapper.this.names().indexName(), "", 0L);
        }
    };

    protected UidFieldMapper() {
        this(CONTENT_TYPE);
    }

    protected UidFieldMapper(String name) {
        this(name, name);
    }

    protected UidFieldMapper(String name, String indexName) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, Field.Store.YES, Defaults.TERM_VECTOR, 1.0f, true, false, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        if (context.id() == null) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
        context.uid(Uid.createUid(context.stringBuilder(), context.type(), context.id()));
        UidField field = this.fieldCache.get();
        field.setUid(context.uid());
        return field;
    }

    @Override
    public Uid value(Fieldable field) {
        return Uid.createUid(field.stringValue());
    }

    @Override
    public Uid valueFromString(String value) {
        return Uid.createUid(value);
    }

    @Override
    public String valueAsString(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    public Term term(String type, String id) {
        return this.term(Uid.createUid(type, id));
    }

    @Override
    public Term term(String uid) {
        return new Term(this.names.indexName(), uid);
    }

    @Override
    public void close() {
        this.fieldCache.remove();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, UidFieldMapper> {
        protected String indexName;

        public Builder() {
            super(UidFieldMapper.CONTENT_TYPE);
            this.indexName = this.name;
        }

        @Override
        public UidFieldMapper build(XContentMapper.BuilderContext context) {
            return new UidFieldMapper(this.name, this.indexName);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_uid";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = false;
    }
}

