/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class IntegerFieldMapper
extends NumberFieldMapper<Integer> {
    public static final String CONTENT_TYPE = "integer";
    private Integer nullValue;
    private String nullValueAsString;

    protected IntegerFieldMapper(FieldMapper.Names names, int precisionStep, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Integer nullValue) {
        super(names, precisionStep, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_int/" + precisionStep, new NumericIntegerAnalyzer(precisionStep)), new NamedAnalyzer("_int/max", new NumericIntegerAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Integer value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToInt(value);
    }

    @Override
    public Integer valueFromString(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.intToPrefixCoded(Integer.parseInt(value));
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newIntRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        int value;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
            } else {
                value = ((Number)externalValue).intValue();
            }
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), Integer.toString(value), this.boost);
            }
        } else if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return null;
            }
            value = this.nullValue;
            if (this.nullValueAsString != null && context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), this.nullValueAsString, this.boost);
            }
        } else {
            value = context.parser().intValue();
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), context.parser().text(), this.boost);
            }
        }
        return new CustomIntegerNumericField((NumberFieldMapper)this, value);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.INT;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((IntegerFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((IntegerFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomIntegerNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final int number;
        private final NumberFieldMapper mapper;

        public CustomIntegerNumericField(NumberFieldMapper mapper, int number) {
            super(mapper, mapper.stored() ? Numbers.intToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        @Override
        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setIntValue(this.number);
            }
            return null;
        }
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.integerField(name);
            XContentTypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IntegerFieldMapper> {
        protected Integer nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(int nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public IntegerFieldMapper build(XContentMapper.BuilderContext context) {
            IntegerFieldMapper fieldMapper = new IntegerFieldMapper(this.buildNames(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Integer NULL_VALUE = null;
    }
}

