/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.shorts;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class ShortFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final short[] values;
    private short bottom;
    private final short missingValue;

    public ShortFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, short missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new short[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.SHORT;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.values[slot1] - this.values[slot2];
    }

    @Override
    public int compareBottom(int doc) {
        short value = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value = this.currentFieldData.shortValue(doc);
        }
        return this.bottom - value;
    }

    @Override
    public void copy(int slot, int doc) {
        short value = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value = this.currentFieldData.shortValue(doc);
        }
        this.values[slot] = value;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Short.valueOf(this.values[slot]);
    }
}

