/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.floats;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.floats.FloatFieldData;
import org.elasticsearch.index.field.data.floats.FloatFieldDataComparator;
import org.elasticsearch.index.field.data.floats.FloatFieldDataMissingComparator;

public class FloatFieldDataType
implements FieldDataType<FloatFieldData> {
    @Override
    public FieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, final String missing) {
        if (missing == null) {
            return new FieldComparatorSource(){

                @Override
                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataComparator(numHits, fieldname, cache);
                }
            };
        }
        if (missing.equals("_last")) {
            return new FieldComparatorSource(){

                @Override
                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Float.MIN_VALUE : Float.MAX_VALUE);
                }
            };
        }
        if (missing.equals("_first")) {
            return new FieldComparatorSource(){

                @Override
                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new FloatFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Float.MAX_VALUE : Float.MIN_VALUE);
                }
            };
        }
        return new FieldComparatorSource(){

            @Override
            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new FloatFieldDataMissingComparator(numHits, fieldname, cache, Float.parseFloat(missing));
            }
        };
    }

    @Override
    public FloatFieldData load(IndexReader reader, String fieldName) throws IOException {
        return FloatFieldData.load(reader, fieldName);
    }
}

