/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class CacheStats
implements Streamable,
ToXContent {
    long fieldEvictions;
    long filterEvictions;
    long filterMemEvictions;
    long filterCount;
    long fieldSize = 0L;
    long filterSize = 0L;
    long bloomSize = 0L;

    public CacheStats() {
    }

    public CacheStats(long fieldEvictions, long filterEvictions, long filterMemEvictions, long fieldSize, long filterSize, long filterCount, long bloomSize) {
        this.fieldEvictions = fieldEvictions;
        this.filterEvictions = filterEvictions;
        this.filterMemEvictions = filterMemEvictions;
        this.fieldSize = fieldSize;
        this.filterSize = filterSize;
        this.filterCount = filterCount;
        this.bloomSize = bloomSize;
    }

    public void add(CacheStats stats) {
        this.fieldEvictions += stats.fieldEvictions;
        this.filterEvictions += stats.filterEvictions;
        this.filterMemEvictions += stats.filterMemEvictions;
        this.fieldSize += stats.fieldSize;
        this.filterSize += stats.filterSize;
        this.filterCount += stats.filterCount;
        this.bloomSize += stats.bloomSize;
    }

    public long fieldEvictions() {
        return this.fieldEvictions;
    }

    public long getFieldEvictions() {
        return this.fieldEvictions();
    }

    public long filterEvictions() {
        return this.filterEvictions;
    }

    public long getFilterEvictions() {
        return this.filterEvictions;
    }

    public long filterMemEvictions() {
        return this.filterEvictions;
    }

    public long getFilterMemEvictions() {
        return this.filterEvictions;
    }

    public long filterCount() {
        return this.filterCount;
    }

    public long getFilterCount() {
        return this.filterCount;
    }

    public long fieldSizeInBytes() {
        return this.fieldSize;
    }

    public long getFieldSizeInBytes() {
        return this.fieldSizeInBytes();
    }

    public ByteSizeValue fieldSize() {
        return new ByteSizeValue(this.fieldSize);
    }

    public ByteSizeValue getFieldSize() {
        return this.fieldSize();
    }

    public long filterSizeInBytes() {
        return this.filterSize;
    }

    public long getFilterSizeInBytes() {
        return this.filterSizeInBytes();
    }

    public ByteSizeValue filterSize() {
        return new ByteSizeValue(this.filterSize);
    }

    public ByteSizeValue getFilterSize() {
        return this.filterSize();
    }

    public long bloomSizeInBytes() {
        return this.bloomSize;
    }

    public long getBloomSizeInBytes() {
        return this.bloomSize;
    }

    public ByteSizeValue bloomSize() {
        return new ByteSizeValue(this.bloomSize);
    }

    public ByteSizeValue getBloomSize() {
        return this.bloomSize();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.CACHE);
        builder.field(Fields.FIELD_EVICTIONS, this.fieldEvictions);
        builder.field(Fields.FIELD_SIZE, this.fieldSize().toString());
        builder.field(Fields.FIELD_SIZE_IN_BYTES, this.fieldSize);
        builder.field(Fields.FILTER_COUNT, this.filterCount);
        builder.field(Fields.FILTER_EVICTIONS, this.filterEvictions);
        builder.field(Fields.FILTER_MEM_EVICTIONS, this.filterMemEvictions);
        builder.field(Fields.FILTER_SIZE, this.filterSize().toString());
        builder.field(Fields.FILTER_SIZE_IN_BYTES, this.filterSize);
        builder.endObject();
        return builder;
    }

    public static CacheStats readCacheStats(StreamInput in) throws IOException {
        CacheStats stats = new CacheStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.fieldEvictions = in.readVLong();
        this.filterEvictions = in.readVLong();
        this.filterMemEvictions = in.readVLong();
        this.fieldSize = in.readVLong();
        this.filterSize = in.readVLong();
        this.filterCount = in.readVLong();
        this.bloomSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fieldEvictions);
        out.writeVLong(this.filterEvictions);
        out.writeVLong(this.filterMemEvictions);
        out.writeVLong(this.fieldSize);
        out.writeVLong(this.filterSize);
        out.writeVLong(this.filterCount);
        out.writeVLong(this.bloomSize);
    }

    static final class Fields {
        static final XContentBuilderString CACHE = new XContentBuilderString("cache");
        static final XContentBuilderString FIELD_SIZE = new XContentBuilderString("field_size");
        static final XContentBuilderString FIELD_SIZE_IN_BYTES = new XContentBuilderString("field_size_in_bytes");
        static final XContentBuilderString FIELD_EVICTIONS = new XContentBuilderString("field_evictions");
        static final XContentBuilderString FILTER_EVICTIONS = new XContentBuilderString("filter_evictions");
        static final XContentBuilderString FILTER_MEM_EVICTIONS = new XContentBuilderString("filter_mem_evictions");
        static final XContentBuilderString FILTER_COUNT = new XContentBuilderString("filter_count");
        static final XContentBuilderString FILTER_SIZE = new XContentBuilderString("filter_size");
        static final XContentBuilderString FILTER_SIZE_IN_BYTES = new XContentBuilderString("filter_size_in_bytes");

        Fields() {
        }
    }
}

