/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.shared;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class SharedStorageGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway,
ClusterStateListener {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public SharedStorageGateway(Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.clusterService.add(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void performStateRecovery(final Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        this.threadPool.cached().execute(new Runnable(){

            @Override
            public void run() {
                SharedStorageGateway.this.logger.debug("reading state from gateway {} ...", this);
                StopWatch stopWatch = new StopWatch().start();
                try {
                    MetaData metaData = SharedStorageGateway.this.read();
                    SharedStorageGateway.this.logger.debug("read state from gateway {}, took {}", this, stopWatch.stop().totalTime());
                    if (metaData == null) {
                        SharedStorageGateway.this.logger.debug("no state read from gateway", new Object[0]);
                        listener.onSuccess(ClusterState.builder().build());
                    } else {
                        listener.onSuccess(ClusterState.builder().metaData(metaData).build());
                    }
                }
                catch (Exception e) {
                    SharedStorageGateway.this.logger.error("failed to read from gateway", e, new Object[0]);
                    listener.onFailure(e);
                }
            }
        });
    }

    @Override
    public void clusterChanged(final ClusterChangedEvent event) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (event.localNodeMaster()) {
            if (!event.metaDataChanged()) {
                return;
            }
            this.threadPool.cached().execute(new Runnable(){

                @Override
                public void run() {
                    SharedStorageGateway.this.logger.debug("writing to gateway {} ...", this);
                    StopWatch stopWatch = new StopWatch().start();
                    try {
                        SharedStorageGateway.this.write(event.state().metaData());
                        SharedStorageGateway.this.logger.debug("wrote to gateway {}, took {}", this, stopWatch.stop().totalTime());
                    }
                    catch (Exception e) {
                        SharedStorageGateway.this.logger.error("failed to write to gateway", e, new Object[0]);
                    }
                }
            });
        }
    }

    protected abstract MetaData read() throws ElasticSearchException;

    protected abstract void write(MetaData var1) throws ElasticSearchException;
}

