/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.common.util.concurrent.jsr166y.TransferQueue;

public class TransferThreadPoolExecutor
extends AbstractExecutorService {
    private final TransferQueue<Runnable> workQueue = new LinkedTransferQueue<Runnable>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private final ThreadFactory threadFactory;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private final boolean blocking;
    private final int blockingCapacity;
    private final long blockingTime;
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final long keepAliveTime;
    private final AtomicInteger poolSize = new AtomicInteger();

    public static TransferThreadPoolExecutor newScalingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        return new TransferThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, false, 0L, TimeUnit.NANOSECONDS, 0, threadFactory);
    }

    public static TransferThreadPoolExecutor newBlockingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, long blockingTime, TimeUnit blockingUnit, int blockingCapacity, ThreadFactory threadFactory) {
        return new TransferThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, true, blockingTime, blockingUnit, blockingCapacity, threadFactory);
    }

    private TransferThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, boolean blocking, long blockingTime, TimeUnit blockingUnit, int blockingCapacity, ThreadFactory threadFactory) {
        this.blocking = blocking;
        this.blockingTime = blockingUnit.toNanos(blockingTime);
        this.blockingCapacity = blockingCapacity;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        for (int i = 0; i < corePoolSize; ++i) {
            Thread t = this.addWorker();
            if (t == null) continue;
            this.poolSize.incrementAndGet();
            t.start();
        }
    }

    @Override
    public void execute(Runnable command) {
        if (this.blocking) {
            this.executeBlocking(command);
        } else {
            this.executeNonBlocking(command);
        }
    }

    private void executeNonBlocking(Runnable command) {
        this.queueSize.getAndIncrement();
        boolean succeeded = this.workQueue.tryTransfer(command);
        if (succeeded) {
            return;
        }
        int currentPoolSize = this.poolSize.get();
        if (currentPoolSize < this.maximumPoolSize) {
            if (this.poolSize.compareAndSet(currentPoolSize, currentPoolSize + 1)) {
                Thread t = this.addWorker();
                if (t == null) {
                    this.poolSize.decrementAndGet();
                    this.workQueue.add(command);
                } else {
                    t.start();
                    succeeded = this.workQueue.tryTransfer(command);
                    if (!succeeded) {
                        this.workQueue.add(command);
                    }
                }
            } else {
                succeeded = this.workQueue.tryTransfer(command);
                if (!succeeded) {
                    this.workQueue.add(command);
                }
            }
        } else {
            this.workQueue.add(command);
        }
    }

    private void executeBlocking(Runnable command) {
        int currentCapacity = this.queueSize.getAndIncrement();
        boolean succeeded = this.workQueue.tryTransfer(command);
        if (succeeded) {
            return;
        }
        int currentPoolSize = this.poolSize.get();
        if (currentPoolSize < this.maximumPoolSize) {
            if (this.poolSize.compareAndSet(currentPoolSize, currentPoolSize + 1)) {
                Thread t = this.addWorker();
                if (t == null) {
                    this.poolSize.decrementAndGet();
                    this.workQueue.add(command);
                } else {
                    t.start();
                    succeeded = this.workQueue.tryTransfer(command);
                    if (!succeeded) {
                        this.transferOrAddBlocking(command, currentCapacity);
                    }
                }
            } else {
                succeeded = this.workQueue.tryTransfer(command);
                if (!succeeded) {
                    this.transferOrAddBlocking(command, currentCapacity);
                }
            }
        } else {
            this.transferOrAddBlocking(command, currentCapacity);
        }
    }

    private void transferOrAddBlocking(Runnable command, int currentCapacity) {
        if (currentCapacity < this.blockingCapacity) {
            this.workQueue.add(command);
        } else {
            try {
                boolean succeeded = this.workQueue.tryTransfer(command, this.blockingTime, TimeUnit.NANOSECONDS);
                if (!succeeded) {
                    throw new RejectedExecutionException("Rejected execution after waiting " + TimeUnit.NANOSECONDS.toSeconds(this.blockingTime) + "s for task [" + command.getClass() + "] to be executed.");
                }
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int state = this.runState;
            if (state < 1) {
                this.runState = 1;
            }
            try {
                for (Worker w : this.workers) {
                    w.interruptIfIdle();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
            this.tryTerminate();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int state = this.runState;
            if (state < 2) {
                this.runState = 2;
            }
            try {
                for (Worker w : this.workers) {
                    w.interruptNow();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
            List<Runnable> tasks = this.drainQueue();
            this.tryTerminate();
            List<Runnable> list = tasks;
            return list;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getPoolSize() {
        return this.poolSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueSize() {
        return this.queueSize.get();
    }

    Runnable getTask() {
        while (true) {
            try {
                do {
                    int state;
                    if ((state = this.runState) > 1) {
                        return null;
                    }
                    Runnable r = state == 1 ? (Runnable)this.workQueue.poll() : (this.poolSize.get() > this.corePoolSize ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take());
                    if (r == null) continue;
                    this.queueSize.decrementAndGet();
                    return r;
                } while (!this.workerCanExit());
                if (this.runState >= 1) {
                    this.interruptIdleWorkers();
                }
                return null;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean workerCanExit() {
        boolean canExit;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            canExit = this.runState >= 2 || this.queueSize.get() == 0 && (this.runState >= 1 || this.poolSize.get() > this.corePoolSize);
        }
        finally {
            mainLock.unlock();
        }
        return canExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfIdle();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.workers.remove(w);
            if (this.poolSize.decrementAndGet() == 0) {
                this.tryTerminate();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void tryTerminate() {
        if (this.poolSize.get() == 0) {
            int state = this.runState;
            if (state < 2 && this.queueSize.get() > 0) {
                state = 0;
                Thread t = this.addThread();
                this.poolSize.incrementAndGet();
                if (t != null) {
                    t.start();
                }
            }
            if (state == 2 || state == 1) {
                this.runState = 3;
                this.termination.signalAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread addWorker() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Thread thread = this.addThread();
            return thread;
        }
        finally {
            mainLock.unlock();
        }
    }

    private Thread addThread() {
        Worker w = new Worker();
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
        }
        return t;
    }

    private List<Runnable> drainQueue() {
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        this.workQueue.drainTo(taskList);
        this.queueSize.getAndAdd(taskList.size() * -1);
        while (!this.workQueue.isEmpty()) {
            Iterator it = this.workQueue.iterator();
            try {
                Runnable r;
                if (!it.hasNext() || !this.workQueue.remove(r = (Runnable)it.next())) continue;
                taskList.add(r);
                this.queueSize.decrementAndGet();
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        return taskList;
    }

    private final class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        Thread thread;

        Worker() {
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    if (this.thread != Thread.currentThread()) {
                        this.thread.interrupt();
                    }
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                if (TransferThreadPoolExecutor.this.runState < 2 && Thread.interrupted() && TransferThreadPoolExecutor.this.runState >= 2) {
                    this.thread.interrupt();
                }
                task.run();
            }
            finally {
                runLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task;
                while ((task = TransferThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                }
            }
            finally {
                TransferThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

