/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class EsExecutors {
    public static ExecutorService newCachedThreadPool(TimeValue keepAlive, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAlive.millis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static String threadName(Settings settings, String namePrefix) {
        String name = settings.get("name");
        name = name == null ? "elasticsearch" : "elasticsearch[" + name + "]";
        return name + namePrefix;
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        final ThreadFactory f = Executors.defaultThreadFactory();
        final String o = namePrefix + "-";
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = f.newThread(r);
                t.setName(o + t.getName());
                t.setDaemon(true);
                return t;
            }
        };
    }

    private EsExecutors() {
    }
}

