/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.unmodifiable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.trove.TCollections;
import org.elasticsearch.common.trove.function.TObjectFunction;
import org.elasticsearch.common.trove.iterator.TFloatObjectIterator;
import org.elasticsearch.common.trove.map.TFloatObjectMap;
import org.elasticsearch.common.trove.procedure.TFloatObjectProcedure;
import org.elasticsearch.common.trove.procedure.TFloatProcedure;
import org.elasticsearch.common.trove.procedure.TObjectProcedure;
import org.elasticsearch.common.trove.set.TFloatSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TUnmodifiableFloatObjectMap<V>
implements TFloatObjectMap<V>,
Serializable {
    private static final long serialVersionUID = -1034234728574286014L;
    private final TFloatObjectMap<V> m;
    private transient TFloatSet keySet = null;
    private transient Collection<V> values = null;

    public TUnmodifiableFloatObjectMap(TFloatObjectMap<V> m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.m = m;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean containsKey(float key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.m.containsValue(val);
    }

    @Override
    public V get(float key) {
        return this.m.get(key);
    }

    @Override
    public V put(float key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(TFloatObjectMap<V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Float, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TFloatSet keySet() {
        if (this.keySet == null) {
            this.keySet = TCollections.unmodifiableSet(this.m.keySet());
        }
        return this.keySet;
    }

    @Override
    public float[] keys() {
        return this.m.keys();
    }

    @Override
    public float[] keys(float[] array) {
        return this.m.keys(array);
    }

    @Override
    public Collection<V> valueCollection() {
        if (this.values == null) {
            this.values = Collections.unmodifiableCollection(this.m.valueCollection());
        }
        return this.values;
    }

    @Override
    public V[] values() {
        return this.m.values();
    }

    @Override
    public <T> T[] values(T[] array) {
        return this.m.values(array);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || ((Object)this.m).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.m).hashCode();
    }

    public String toString() {
        return this.m.toString();
    }

    @Override
    public float getNoEntryKey() {
        return this.m.getNoEntryKey();
    }

    @Override
    public boolean forEachKey(TFloatProcedure procedure) {
        return this.m.forEachKey(procedure);
    }

    @Override
    public boolean forEachValue(TObjectProcedure<V> procedure) {
        return this.m.forEachValue(procedure);
    }

    @Override
    public boolean forEachEntry(TFloatObjectProcedure<V> procedure) {
        return this.m.forEachEntry(procedure);
    }

    @Override
    public TFloatObjectIterator<V> iterator() {
        return new TFloatObjectIterator<V>(){
            TFloatObjectIterator<V> iter;
            {
                this.iter = TUnmodifiableFloatObjectMap.this.m.iterator();
            }

            @Override
            public float key() {
                return this.iter.key();
            }

            @Override
            public V value() {
                return this.iter.value();
            }

            @Override
            public void advance() {
                this.iter.advance();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public V setValue(V val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public V putIfAbsent(float key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TObjectFunction<V, V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainEntries(TFloatObjectProcedure<V> procedure) {
        throw new UnsupportedOperationException();
    }
}

