/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class TermFilter
extends Filter {
    private final Term term;

    public TermFilter(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        OpenBitSet result = new OpenBitSet(reader.maxDoc());
        TermDocs td = reader.termDocs();
        try {
            td.seek(this.term);
            while (td.next()) {
                result.fastSet(td.doc());
            }
        }
        finally {
            td.close();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermFilter that = (TermFilter)o;
        return !(this.term != null ? !this.term.equals(that.term) : that.term != null);
    }

    public int hashCode() {
        return this.term != null ? this.term.hashCode() : 0;
    }

    public String toString() {
        return this.term.field() + ":" + this.term.text();
    }
}

