/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchInterruptedException;
import org.elasticsearch.ElasticSearchTimeoutException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractFuture;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;

public abstract class AdapterActionFuture<T, L>
extends AbstractFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    @Override
    public T actionGet() throws ElasticSearchException {
        try {
            return (T)this.get();
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticSearchException) {
                throw (ElasticSearchException)e.getCause();
            }
            throw new UncategorizedExecutionException("Failed execution", e);
        }
    }

    @Override
    public T actionGet(String timeout) throws ElasticSearchException {
        return this.actionGet(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public T actionGet(long timeoutMillis) throws ElasticSearchException {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) throws ElasticSearchException {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) throws ElasticSearchException {
        try {
            return (T)this.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ElasticSearchTimeoutException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticSearchException) {
                throw (ElasticSearchException)e.getCause();
            }
            throw new UncategorizedExecutionException("Failed execution", e);
        }
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Throwable e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);
}

