/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchRequest
implements ActionRequest {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices;
    @Nullable
    private String queryHint;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private boolean sourceUnsafe;
    private byte[] extraSource;
    private int extraSourceOffset;
    private int extraSourceLength;
    private boolean extraSourceUnsafe;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private TimeValue timeout;
    private boolean listenerThreaded = false;
    private SearchOperationThreading operationThreading = SearchOperationThreading.THREAD_PER_SHARD;

    public SearchRequest() {
    }

    public SearchRequest(String ... indices) {
        this.indices = indices;
    }

    public SearchRequest(String[] indices, byte[] source) {
        this.indices = indices;
        this.source = source;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.source == null && this.extraSource == null) {
            validationException = Actions.addValidationError("search source is missing", validationException);
        }
        return validationException;
    }

    public void beforeLocalFork() {
        if (this.source != null && this.sourceUnsafe) {
            this.source = Arrays.copyOfRange(this.source, this.sourceOffset, this.sourceOffset + this.sourceLength);
            this.sourceOffset = 0;
            this.sourceUnsafe = false;
        }
        if (this.extraSource != null && this.extraSourceUnsafe) {
            this.extraSource = Arrays.copyOfRange(this.extraSource, this.extraSourceOffset, this.extraSourceOffset + this.extraSourceLength);
            this.extraSourceOffset = 0;
            this.extraSourceUnsafe = false;
        }
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    public SearchRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public SearchRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    public SearchOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public SearchRequest operationThreading(SearchOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return this;
    }

    public SearchRequest operationThreading(String operationThreading) {
        return this.operationThreading(SearchOperationThreading.fromString(operationThreading, this.operationThreading));
    }

    public String[] types() {
        return this.types;
    }

    public SearchRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchRequest searchType(String searchType) throws ElasticSearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        FastByteArrayOutputStream bos = sourceBuilder.buildAsUnsafeBytes(Requests.CONTENT_TYPE);
        this.source = bos.unsafeByteArray();
        this.sourceOffset = 0;
        this.sourceLength = bos.size();
        this.sourceUnsafe = true;
        return this;
    }

    public SearchRequest source(String source) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(source);
        this.source = result.result;
        this.sourceOffset = 0;
        this.sourceLength = result.length;
        this.sourceUnsafe = true;
        return this;
    }

    public SearchRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public SearchRequest source(XContentBuilder builder) {
        try {
            this.source = builder.unsafeBytes();
            this.sourceOffset = 0;
            this.sourceLength = builder.unsafeBytesLength();
            this.sourceUnsafe = true;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    public SearchRequest source(byte[] source) {
        return this.source(source, 0, source.length, false);
    }

    public SearchRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    public SearchRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public byte[] source() {
        return this.source;
    }

    public int sourceOffset() {
        return this.sourceOffset;
    }

    public int sourceLength() {
        return this.sourceLength;
    }

    public SearchRequest extraSource(SearchSourceBuilder sourceBuilder) {
        FastByteArrayOutputStream bos = sourceBuilder.buildAsUnsafeBytes(Requests.CONTENT_TYPE);
        this.extraSource = bos.unsafeByteArray();
        this.extraSourceOffset = 0;
        this.extraSourceLength = bos.size();
        this.extraSourceUnsafe = true;
        return this;
    }

    public SearchRequest extraSource(Map extraSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(extraSource);
            return this.extraSource(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + this.source + "]", e);
        }
    }

    public SearchRequest extraSource(XContentBuilder builder) {
        try {
            this.extraSource = builder.unsafeBytes();
            this.extraSourceOffset = 0;
            this.extraSourceLength = builder.unsafeBytesLength();
            this.extraSourceUnsafe = true;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    public SearchRequest extraSource(String source) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(source);
        this.extraSource = result.result;
        this.extraSourceOffset = 0;
        this.extraSourceLength = result.length;
        this.extraSourceUnsafe = true;
        return this;
    }

    public SearchRequest extraSource(byte[] source) {
        return this.extraSource(source, 0, source.length, false);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length) {
        return this.extraSource(source, offset, length, false);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length, boolean unsafe) {
        this.extraSource = source;
        this.extraSourceOffset = offset;
        this.extraSourceLength = length;
        this.extraSourceUnsafe = unsafe;
        return this;
    }

    public byte[] extraSource() {
        return this.extraSource;
    }

    public int extraSourceOffset() {
        return this.extraSourceOffset;
    }

    public int extraSourceLength() {
        return this.extraSourceLength;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public String[] indices() {
        return this.indices;
    }

    public SearchRequest queryHint(String queryHint) {
        this.queryHint = queryHint;
        return this;
    }

    public String queryHint() {
        return this.queryHint;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public SearchRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public SearchRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.operationThreading = SearchOperationThreading.fromId(in.readByte());
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readUTF();
        }
        if (in.readBoolean()) {
            this.queryHint = in.readUTF();
        }
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        if (in.readBoolean()) {
            this.preference = in.readUTF();
        }
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue(in);
        }
        this.sourceUnsafe = false;
        this.sourceOffset = 0;
        this.sourceLength = in.readVInt();
        if (this.sourceLength == 0) {
            this.source = Bytes.EMPTY_ARRAY;
        } else {
            this.source = new byte[this.sourceLength];
            in.readFully(this.source);
        }
        this.extraSourceUnsafe = false;
        this.extraSourceOffset = 0;
        this.extraSourceLength = in.readVInt();
        if (this.extraSourceLength == 0) {
            this.extraSource = Bytes.EMPTY_ARRAY;
        } else {
            this.extraSource = new byte[this.extraSourceLength];
            in.readFully(this.extraSource);
        }
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.operationThreading.id());
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeUTF(index);
        }
        if (this.queryHint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryHint);
        }
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        if (this.preference == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.preference);
        }
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        if (this.timeout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        }
        if (this.source == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.sourceLength);
            out.writeBytes(this.source, this.sourceOffset, this.sourceLength);
        }
        if (this.extraSource == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.extraSourceLength);
            out.writeBytes(this.extraSource, this.extraSourceOffset, this.extraSourceLength);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
    }
}

