/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardCountRequest
extends BroadcastShardOperationRequest {
    private float minScore;
    private byte[] querySource;
    private int querySourceOffset;
    private int querySourceLength;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String queryParserName;

    ShardCountRequest() {
    }

    public ShardCountRequest(String index, int shardId, CountRequest request) {
        super(index, shardId);
        this.minScore = request.minScore();
        this.querySource = request.querySource();
        this.querySourceOffset = request.querySourceOffset();
        this.querySourceLength = request.querySourceLength();
        this.queryParserName = request.queryParserName();
        this.types = request.types();
    }

    public float minScore() {
        return this.minScore;
    }

    public byte[] querySource() {
        return this.querySource;
    }

    public int querySourceOffset() {
        return this.querySourceOffset;
    }

    public int querySourceLength() {
        return this.querySourceLength;
    }

    public String queryParserName() {
        return this.queryParserName;
    }

    public String[] types() {
        return this.types;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int typesSize;
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.querySourceLength = in.readVInt();
        this.querySourceOffset = 0;
        this.querySource = new byte[this.querySourceLength];
        in.readFully(this.querySource);
        if (in.readBoolean()) {
            this.queryParserName = in.readUTF();
        }
        if ((typesSize = in.readVInt()) > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeVInt(this.querySourceLength);
        out.writeBytes(this.querySource, this.querySourceOffset, this.querySourceLength);
        if (this.queryParserName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryParserName);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
    }
}

