/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.th.ThaiWordFilter;
import org.apache.lucene.util.Version;

public final class ThaiAnalyzer
extends ReusableAnalyzerBase {
    private final Version matchVersion;

    public ThaiAnalyzer(Version matchVersion) {
        this.matchVersion = matchVersion;
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result = new StandardFilter(this.matchVersion, source);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            result = new LowerCaseFilter(this.matchVersion, result);
        }
        result = new ThaiWordFilter(this.matchVersion, result);
        return new ReusableAnalyzerBase.TokenStreamComponents(source, new StopFilter(this.matchVersion, (TokenStream)result, StopAnalyzer.ENGLISH_STOP_WORDS_SET));
    }
}

