/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Retained;
import org.fusesource.hawtdispatch.transport.PipeTransportServer;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeTransport
implements Transport {
    private static final Object EOF_TOKEN = new Object();
    private final PipeTransportServer server;
    PipeTransport peer;
    private TransportListener listener;
    private SocketAddress remoteAddress;
    private AtomicBoolean stopping = new AtomicBoolean();
    private String name;
    private boolean marshal;
    private boolean trace;
    private DispatchQueue dispatchQueue;
    private CustomDispatchSource<Object, LinkedList<Object>> dispatchSource;
    private boolean connected;
    private long writeCounter = 0L;
    private long readCounter = 0L;
    private ProtocolCodec protocolCodec;
    int outbound = 0;
    int maxOutbound = 100;

    public PipeTransport(PipeTransportServer server) {
        this.server = server;
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    @Override
    public void start(final Runnable onCompleted) {
        if (this.dispatchQueue == null) {
            throw new IllegalArgumentException("dispatchQueue is not set");
        }
        this.server.dispatchQueue.execute(new Runnable(){

            public void run() {
                PipeTransport.this.dispatchSource = Dispatch.createSource((EventAggregator)EventAggregators.linkedList(), (DispatchQueue)PipeTransport.this.dispatchQueue);
                PipeTransport.this.dispatchSource.setEventHandler(new Runnable(){

                    public void run() {
                        try {
                            final LinkedList commands = (LinkedList)PipeTransport.this.dispatchSource.getData();
                            for (Object o : commands) {
                                if (o == EOF_TOKEN) {
                                    throw new EOFException();
                                }
                                PipeTransport.this.readCounter++;
                                PipeTransport.this.listener.onTransportCommand(o);
                            }
                            PipeTransport.this.peer.dispatchQueue.execute(new Runnable(){

                                public void run() {
                                    PipeTransport.this.outbound -= commands.size();
                                    PipeTransport.this.drainInbound();
                                }
                            });
                        }
                        catch (IOException e) {
                            PipeTransport.this.listener.onTransportFailure(e);
                        }
                    }
                });
                if (PipeTransport.this.peer.dispatchSource != null) {
                    PipeTransport.this.fireConnected();
                    PipeTransport.this.peer.fireConnected();
                }
                if (onCompleted != null) {
                    onCompleted.run();
                }
            }
        });
    }

    private void fireConnected() {
        this.dispatchQueue.execute(new Runnable(){

            public void run() {
                PipeTransport.this.connected = true;
                PipeTransport.this.dispatchSource.resume();
                PipeTransport.this.listener.onTransportConnected();
                PipeTransport.this.drainInbound();
            }
        });
    }

    @Override
    public void flush() {
        this.listener.onRefill();
    }

    @Override
    public void stop(Runnable onCompleted) {
        if (this.connected) {
            this.peer.dispatchSource.merge(EOF_TOKEN);
        }
        if (this.dispatchSource != null) {
            this.dispatchSource.setCancelHandler(onCompleted);
            this.dispatchSource.cancel();
        }
        this.setDispatchQueue(null);
    }

    @Override
    public boolean full() {
        return this.outbound >= this.maxOutbound;
    }

    @Override
    public boolean offer(Object command) {
        if (!this.connected) {
            return false;
        }
        if (this.full()) {
            return false;
        }
        this.transmit(command);
        return true;
    }

    private void drainInbound() {
        if (!this.full()) {
            this.listener.onRefill();
        }
    }

    private void transmit(Object command) {
        ++this.writeCounter;
        ++this.outbound;
        this.peer.dispatchSource.merge(command);
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public <T> T narrow(Class<T> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return target.cast(this);
        }
        return null;
    }

    @Override
    public void suspendRead() {
        this.dispatchSource.suspend();
    }

    @Override
    public void resumeRead() {
        this.dispatchSource.resume();
    }

    @Override
    public void reconnect(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTypeId() {
        return "pipe";
    }

    public void setRemoteAddress(final String remoteAddress) {
        this.remoteAddress = new SocketAddress(){

            public String toString() {
                return remoteAddress;
            }
        };
        if (this.name == null) {
            this.name = remoteAddress;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public ProtocolCodec getProtocolCodec() {
        return this.protocolCodec;
    }

    @Override
    public void setProtocolCodec(ProtocolCodec protocolCodec) {
        this.protocolCodec = protocolCodec;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshall) {
        this.marshal = marshall;
    }

    @Override
    public boolean isConnected() {
        return !this.stopping.get();
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public boolean isFaultTolerant() {
        return false;
    }

    static final class OneWay {
        final Object command;
        final Retained retained;

        public OneWay(Object command, Retained retained) {
            this.command = command;
            this.retained = retained;
        }
    }
}

