/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.example.discovery;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;

public class EchoNetJava {
    public static void main(String[] args) throws Exception {
        EchoNetJava.run();
    }

    public static void run() throws Exception {
        Server a = new Server(4444).start();
        Server b = new Server(5555).start();
        Server c = new Server(6666).start();
        Thread.sleep(200L);
        a.connect(3333);
        a.connect(b);
        b.connect(c);
        System.in.read();
    }

    static class Session {
        Server server;
        SocketChannel channel;
        InetSocketAddress address;
        URI uri;
        ByteBuffer read_buffer = ByteBuffer.allocate(1024);
        DispatchQueue queue;
        DispatchSource read_source;
        DispatchSource write_source;
        ArrayList<URI> seen;
        ArrayList<URI> listed = new ArrayList();

        public Session(Server server, SocketChannel channel, InetSocketAddress address, URI uri) {
            this.server = server;
            this.channel = channel;
            this.address = address;
            this.uri = uri;
            this.queue = Dispatch.createQueue((String)uri.toString());
            this.read_source = Dispatch.createSource((SelectableChannel)channel, (int)1, (DispatchQueue)this.queue);
            this.write_source = Dispatch.createSource((SelectableChannel)channel, (int)4, (DispatchQueue)this.queue);
            this.seen = new ArrayList<URI>(server.seen);
        }

        public Session(Server server, SocketChannel channel, InetSocketAddress address) {
            this(server, channel, address, URI.create("conn://" + address.getHostName() + ":" + address.getPort()));
        }

        public void start_read_greeting() {
            this.read_source.setEventHandler(this.read_greeting());
            this.read_source.resume();
        }

        public Runnable read_greeting() {
            return new Runnable(){

                public void run() {
                    try {
                        String message2 = Session.this.read_frame();
                        if (message2 != null) {
                            Session.this.read_source.suspend();
                            URI uri = URI.create(message2);
                            Session.this.trace("welcome");
                            ArrayList<URI> list = new ArrayList<URI>(Session.this.seen);
                            list.remove(Session.this.server.me);
                            list.remove(uri);
                            list.add((URI)((Object)"end"));
                            Session.this.start_write_data(new Runnable(){

                                public void run() {
                                    Session.this.start_read_hearbeat();
                                }
                            }, list.toArray(new Object[list.size()]));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }

        public void start_write_greeting() throws IOException {
            this.trace("hello");
            this.start_write_data(new Runnable(){

                public void run() {
                    Session.this.start_read_server_listings();
                }
            }, this.server.me);
        }

        public void start_read_server_listings() {
            this.read_source.setEventHandler(this.read_server_listings());
            this.read_source.resume();
        }

        public Runnable read_server_listings() {
            return new Runnable(){

                public void run() {
                    try {
                        String message2 = Session.this.read_frame();
                        if (message2 != null) {
                            if (!message2.equals("end")) {
                                URI uri = URI.create(message2);
                                Session.this.listed.add(uri);
                                Session.this.server.connect(uri);
                            } else {
                                ArrayList<URI> list = new ArrayList<URI>(Session.this.seen);
                                list.removeAll(Session.this.listed);
                                list.remove(Session.this.server.me);
                                list.add((URI)((Object)"end"));
                                Session.this.start_write_data(new Runnable(){

                                    public void run() {
                                        Session.this.start_write_hearbeat();
                                    }
                                }, list.toArray(new Object[list.size()]));
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }

        public void start_read_client_listings() {
            this.read_source.setEventHandler(this.read_clientlistings());
            this.read_source.resume();
        }

        public Runnable read_clientlistings() {
            return new Runnable(){

                public void run() {
                    try {
                        String message2 = Session.this.read_frame();
                        if (message2 != null) {
                            if (!message2.equals("end")) {
                                Session.this.server.connect(URI.create(message2));
                            } else {
                                Session.this.start_read_hearbeat();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }

        public void start_write_hearbeat() {
            this.queue.dispatchAfter(1L, TimeUnit.SECONDS, new Runnable(){

                public void run() {
                    try {
                        Session.this.trace("ping");
                        Session.this.start_write_data(new Runnable(){

                            public void run() {
                                Session.this.start_write_hearbeat();
                            }
                        }, "ping");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public void start_read_hearbeat() {
            this.read_source.setEventHandler(this.read_hearbeat());
            this.read_source.resume();
        }

        public Runnable read_hearbeat() {
            return new Runnable(){

                public void run() {
                    try {
                        String message2 = Session.this.read_frame();
                        if (message2 != null) {
                            Session.this.trace("pong");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }

        public void start_write_data(Runnable onDone, Object ... list) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (Object next : list) {
                baos.write(next.toString().getBytes("UTF-8"));
                baos.write(0);
            }
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            this.write_source.setEventHandler(this.write_data(buffer, onDone));
            this.write_source.resume();
        }

        public Runnable write_data(final ByteBuffer buffer, final Runnable onDone) {
            return new Runnable(){

                public void run() {
                    try {
                        Session.this.channel.write(buffer);
                        if (buffer.remaining() == 0) {
                            Session.this.write_source.suspend();
                            onDone.run();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }

        public String read_frame() throws IOException {
            if (this.channel.read(this.read_buffer) == -1) {
                throw new EOFException();
            }
            byte[] buf = this.read_buffer.array();
            int endPos = this.eof(buf, 0, this.read_buffer.position());
            if (endPos < 0) {
                this.trace(" --- ");
                return null;
            }
            String rc = new String(buf, 0, endPos);
            int newPos = this.read_buffer.position() - endPos;
            System.arraycopy(buf, endPos + 1, buf, 0, newPos);
            this.read_buffer.position(newPos);
            return rc;
        }

        public int eof(byte[] data, int offset, int pos) {
            for (int i = offset; i < pos; ++i) {
                if (data[i] != 0) continue;
                return i;
            }
            return -1;
        }

        public void trace(String str) {
            System.out.println(String.format("%5d %5d - %s", this.server.port, this.uri.getPort(), str));
        }
    }

    static class Server {
        final int port;
        final URI me;
        final ServerSocketChannel serverChannel;
        final ArrayList<URI> seen = new ArrayList();
        final DispatchQueue queue;
        final DispatchSource accept_source;

        public Server(int port) throws Exception {
            this.port = port;
            this.me = URI.create("conn://localhost:" + port);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.socket().bind(new InetSocketAddress(port));
            this.serverChannel.configureBlocking(false);
            this.queue = Dispatch.createQueue((String)this.me.toString());
            this.accept_source = Dispatch.createSource((SelectableChannel)this.serverChannel, (int)16, (DispatchQueue)this.queue);
            this.accept_source.setEventHandler(new Runnable(){

                public void run() {
                    SocketChannel client = null;
                    try {
                        client = Server.this.serverChannel.accept();
                        InetSocketAddress address = (InetSocketAddress)client.socket().getRemoteSocketAddress();
                        Server.this.trace("accept " + address.getPort());
                        client.configureBlocking(false);
                        Session session = new Session(Server.this, client, address);
                        session.start_read_greeting();
                    }
                    catch (Exception e) {
                        try {
                            client.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.accept_source.setCancelHandler(new Runnable(){

                public void run() {
                    try {
                        Server.this.serverChannel.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.trace("Listening");
        }

        public Server start() {
            this.accept_source.resume();
            return this;
        }

        public void stop() {
            this.accept_source.suspend();
        }

        public void close() {
            this.accept_source.release();
            this.queue.release();
        }

        public void connect(Server s) {
            this.connect(s.port);
        }

        public void connect(int port) {
            this.connect(URI.create("conn://localhost:" + port));
        }

        public void connect(final URI uri) {
            this.queue.dispatchAsync(new Runnable(){

                public void run() {
                    if (Server.this.me.equals(uri) || Server.this.seen.contains(uri)) {
                        return;
                    }
                    try {
                        int port = uri.getPort();
                        String host = uri.getHost();
                        Server.this.trace("open " + uri);
                        final SocketChannel socketChannel = SocketChannel.open();
                        socketChannel.configureBlocking(false);
                        final InetSocketAddress address = new InetSocketAddress(host, port);
                        socketChannel.connect(address);
                        final DispatchSource connect_source = Dispatch.createSource((SelectableChannel)socketChannel, (int)8, (DispatchQueue)Server.this.queue);
                        connect_source.setEventHandler(new Runnable(){

                            public void run() {
                                connect_source.release();
                                try {
                                    socketChannel.finishConnect();
                                    Server.this.trace("connected " + uri);
                                    Session session = new Session(Server.this, socketChannel, address, uri);
                                    session.start_write_greeting();
                                }
                                catch (IOException e) {
                                    Server.this.trace("connect to " + uri + " FAILED.");
                                }
                            }
                        });
                        connect_source.resume();
                        Server.this.seen.add(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public void trace(String str) {
            System.out.println(String.format("%5d       - %s", this.port, str));
        }
    }
}

