/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.hawtbuf.proto.compiler.EnumDescriptor;
import org.fusesource.hawtbuf.proto.compiler.EnumFieldDescriptor;
import org.fusesource.hawtbuf.proto.compiler.ExtensionsDescriptor;
import org.fusesource.hawtbuf.proto.compiler.FieldDescriptor;
import org.fusesource.hawtbuf.proto.compiler.OptionDescriptor;
import org.fusesource.hawtbuf.proto.compiler.ProtoDescriptor;
import org.fusesource.hawtbuf.proto.compiler.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDescriptor
implements TypeDescriptor {
    private String name;
    private ExtensionsDescriptor extensions;
    private Map<String, FieldDescriptor> fields = new LinkedHashMap<String, FieldDescriptor>();
    private Map<String, MessageDescriptor> messages = new LinkedHashMap<String, MessageDescriptor>();
    private Map<String, EnumDescriptor> enums = new LinkedHashMap<String, EnumDescriptor>();
    private final ProtoDescriptor protoDescriptor;
    private List<MessageDescriptor> extendsList = new ArrayList<MessageDescriptor>();
    private Map<String, OptionDescriptor> options = new LinkedHashMap<String, OptionDescriptor>();
    private List<EnumFieldDescriptor> associatedEnumFieldDescriptors = new ArrayList<EnumFieldDescriptor>();
    private final MessageDescriptor parent;
    private MessageDescriptor baseType;

    public MessageDescriptor(ProtoDescriptor protoDescriptor, MessageDescriptor parent) {
        this.protoDescriptor = protoDescriptor;
        this.parent = parent;
    }

    public void validate(List<String> errors) {
        String baseName = this.getOption(this.getOptions(), "base_type", null);
        if (baseName != null) {
            if (this.baseType == null) {
                this.baseType = (MessageDescriptor)this.getType(baseName);
            }
            if (this.baseType == null) {
                this.baseType = (MessageDescriptor)this.getProtoDescriptor().getType(baseName);
            }
            if (this.baseType == null) {
                errors.add("base_type option not valid, type not found: " + baseName);
            }
            HashSet<String> baseFieldNames = new HashSet<String>(this.baseType.getFields().keySet());
            baseFieldNames.removeAll(this.getFields().keySet());
            if (!baseFieldNames.isEmpty()) {
                for (String fieldName : baseFieldNames) {
                    errors.add("base_type " + baseName + " field " + fieldName + " not defined in " + this.getName());
                }
            }
        }
        for (FieldDescriptor fieldDescriptor : this.fields.values()) {
            fieldDescriptor.validate(errors);
        }
        for (EnumDescriptor enumDescriptor : this.enums.values()) {
            enumDescriptor.validate(errors);
        }
        for (MessageDescriptor messageDescriptor : this.messages.values()) {
            messageDescriptor.validate(errors);
        }
    }

    public String getOption(Map<String, OptionDescriptor> options, String optionName, String defaultValue) {
        OptionDescriptor optionDescriptor = options.get(optionName);
        if (optionDescriptor == null) {
            return defaultValue;
        }
        return optionDescriptor.getValue();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtensions(ExtensionsDescriptor extensions) {
        this.extensions = extensions;
    }

    public void setExtends(List<MessageDescriptor> extendsList) {
        this.extendsList = extendsList;
    }

    public List<MessageDescriptor> getExtends() {
        return this.extendsList;
    }

    public void setFields(Map<String, FieldDescriptor> fields) {
        this.fields = fields;
    }

    public void setMessages(Map<String, MessageDescriptor> messages) {
        this.messages = messages;
    }

    public void setEnums(Map<String, EnumDescriptor> enums) {
        this.enums = enums;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getQName() + "." + this.name;
    }

    public ExtensionsDescriptor getExtensions() {
        return this.extensions;
    }

    public Map<String, FieldDescriptor> getFields() {
        return this.fields;
    }

    public Map<String, MessageDescriptor> getMessages() {
        return this.messages;
    }

    public Map<String, EnumDescriptor> getEnums() {
        return this.enums;
    }

    @Override
    public ProtoDescriptor getProtoDescriptor() {
        return this.protoDescriptor;
    }

    public Map<String, OptionDescriptor> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, OptionDescriptor> options) {
        this.options = options;
    }

    public MessageDescriptor getParent() {
        return this.parent;
    }

    public TypeDescriptor getType(String t) {
        for (MessageDescriptor messageDescriptor : this.messages.values()) {
            if (t.equals(messageDescriptor.getName())) {
                return messageDescriptor;
            }
            if (!t.startsWith(messageDescriptor.getName() + ".")) continue;
            return messageDescriptor.getType(t.substring(messageDescriptor.getName().length() + 1));
        }
        for (EnumDescriptor enumDescriptor : this.enums.values()) {
            if (!t.equals(enumDescriptor.getName())) continue;
            return enumDescriptor;
        }
        return null;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    public MessageDescriptor getBaseType() {
        return this.baseType;
    }

    @Override
    public void associate(EnumFieldDescriptor desc) {
        this.associatedEnumFieldDescriptors.add(desc);
    }

    public List<EnumFieldDescriptor> getAssociatedEnumFieldDescriptors() {
        return this.associatedEnumFieldDescriptors;
    }
}

