/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.mqtt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class TopicPB
implements PBMessageFactory<Bean, Buffer> {
    public static final TopicPB FACTORY = new TopicPB();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasName() {
            return this.bean().hasName();
        }

        @Override
        public UTF8Buffer getName() {
            return this.bean().getName();
        }

        @Override
        public boolean hasQos() {
            return this.bean().hasQos();
        }

        @Override
        public int getQos() {
            return this.bean().getQos();
        }

        @Override
        public boolean hasAddress() {
            return this.bean().hasAddress();
        }

        @Override
        public UTF8Buffer getAddress() {
            return this.bean().getAddress();
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                if (this.bean.hasName()) {
                    output.writeBytes(1, (org.fusesource.hawtbuf.Buffer)this.bean.getName());
                }
                if (this.bean.hasQos()) {
                    output.writeInt32(2, this.bean.getQos());
                }
                if (this.bean.hasAddress()) {
                    output.writeBytes(3, (org.fusesource.hawtbuf.Buffer)this.bean.getAddress());
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.hasName()) {
                this.size += CodedOutputStream.computeBytesSize((int)1, (org.fusesource.hawtbuf.Buffer)this.getName());
            }
            if (this.hasQos()) {
                this.size += CodedOutputStream.computeInt32Size((int)2, (int)this.getQos());
            }
            if (this.hasAddress()) {
                this.size += CodedOutputStream.computeBytesSize((int)3, (org.fusesource.hawtbuf.Buffer)this.getAddress());
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private UTF8Buffer f_name = null;
        private int f_qos = 0;
        private boolean b_qos;
        private UTF8Buffer f_address = null;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_name = other.f_name;
            this.f_qos = other.f_qos;
            this.b_qos = other.b_qos;
            this.f_address = other.f_address;
        }

        @Override
        public boolean hasName() {
            return this.bean.f_name != null;
        }

        @Override
        public UTF8Buffer getName() {
            return this.bean.f_name;
        }

        public Bean setName(UTF8Buffer name) {
            this.copyCheck();
            this.f_name = name;
            return this;
        }

        public void clearName() {
            this.copyCheck();
            this.f_name = null;
        }

        @Override
        public boolean hasQos() {
            return this.bean.b_qos;
        }

        @Override
        public int getQos() {
            return this.bean.f_qos;
        }

        public Bean setQos(int qos) {
            this.copyCheck();
            this.b_qos = true;
            this.f_qos = qos;
            return this;
        }

        public void clearQos() {
            this.copyCheck();
            this.b_qos = false;
            this.f_qos = 0;
        }

        @Override
        public boolean hasAddress() {
            return this.bean.f_address != null;
        }

        @Override
        public UTF8Buffer getAddress() {
            return this.bean.f_address;
        }

        public Bean setAddress(UTF8Buffer address) {
            this.copyCheck();
            this.f_address = address;
            return this;
        }

        public void clearAddress() {
            this.copyCheck();
            this.f_address = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            if (this.hasName()) {
                sb.append(prefix + "name: ");
                sb.append(this.getName());
                sb.append("\n");
            }
            if (this.hasQos()) {
                sb.append(prefix + "qos: ");
                sb.append(this.getQos());
                sb.append("\n");
            }
            if (this.hasAddress()) {
                sb.append(prefix + "address: ");
                sb.append(this.getAddress());
                sb.append("\n");
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block6: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        continue block6;
                    }
                    case 10: {
                        this.setName(new UTF8Buffer(input.readBytes()));
                        continue block6;
                    }
                    case 16: {
                        this.setQos(input.readInt32());
                        continue block6;
                    }
                    case 26: 
                }
                this.setAddress(new UTF8Buffer(input.readBytes()));
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasName() ^ obj.hasName()) {
                return false;
            }
            if (this.hasName() && !this.getName().equals((org.fusesource.hawtbuf.Buffer)obj.getName())) {
                return false;
            }
            if (this.hasQos() ^ obj.hasQos()) {
                return false;
            }
            if (this.hasQos() && this.getQos() != obj.getQos()) {
                return false;
            }
            if (this.hasAddress() ^ obj.hasAddress()) {
                return false;
            }
            return !this.hasAddress() || this.getAddress().equals((org.fusesource.hawtbuf.Buffer)obj.getAddress());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasName()) {
                rc ^= 0x24EEAB ^ this.getName().hashCode();
            }
            if (this.hasQos()) {
                rc ^= 0x13DF5 ^ this.getQos();
            }
            if (this.hasAddress()) {
                rc ^= 0x1ED033D4 ^ this.getAddress().hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasName()) {
                this.setName(other.getName());
            }
            if (other.hasQos()) {
                this.setQos(other.getQos());
            }
            if (other.hasAddress()) {
                this.setAddress(other.getAddress());
            }
            return this;
        }

        public void clear() {
            this.clearName();
            this.clearQos();
            this.clearAddress();
        }

        public void readExternal(DataInput in) throws IOException {
            byte[] b;
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            int size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_name = new UTF8Buffer(b);
            } else {
                this.f_name = null;
            }
            this.f_qos = in.readInt();
            this.b_qos = true;
            size = in.readInt();
            if (size >= 0) {
                b = new byte[size];
                in.readFully(b);
                this.f_address = new UTF8Buffer(b);
            } else {
                this.f_address = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            if (this.bean.f_name != null) {
                out.writeInt(this.bean.f_name.getLength());
                out.write(this.bean.f_name.getData(), this.bean.f_name.getOffset(), this.bean.f_name.getLength());
            } else {
                out.writeInt(-1);
            }
            out.writeInt(this.bean.f_qos);
            if (this.bean.f_address != null) {
                out.writeInt(this.bean.f_address.getLength());
                out.write(this.bean.f_address.getData(), this.bean.f_address.getOffset(), this.bean.f_address.getLength());
            } else {
                out.writeInt(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasName();

        public UTF8Buffer getName();

        public boolean hasQos();

        public int getQos();

        public boolean hasAddress();

        public UTF8Buffer getAddress();

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

