/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.mqtt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.activemq.apollo.mqtt.TopicPB;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.MessageBuffer;
import org.fusesource.hawtbuf.proto.MessageBufferSupport;
import org.fusesource.hawtbuf.proto.PBMessage;
import org.fusesource.hawtbuf.proto.PBMessageFactory;
import org.fusesource.hawtbuf.proto.PBMessageFramedCodec;
import org.fusesource.hawtbuf.proto.PBMessageUnframedCodec;

public class SessionPB
implements PBMessageFactory<Bean, Buffer> {
    public static final SessionPB FACTORY = new SessionPB();
    public static final PBMessageFramedCodec<Buffer> FRAMED_CODEC = new PBMessageFramedCodec((PBMessageFactory)FACTORY);
    public static final PBMessageUnframedCodec<Buffer> UNFRAMED_CODEC = new PBMessageUnframedCodec((PBMessageFactory)FACTORY);

    public Bean create() {
        return new Bean();
    }

    public Bean parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return new Bean().mergeUnframed(data);
    }

    public Bean parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(new CodedInputStream(data));
    }

    public Buffer parseUnframed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        return new Buffer(data);
    }

    public Buffer parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseUnframed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        int length = data.readRawVarint32();
        int oldLimit = data.pushLimit(length);
        Buffer rc = this.parseUnframed(data.readRawBytes(length));
        data.popLimit(oldLimit);
        return rc;
    }

    public Buffer parseFramed(org.fusesource.hawtbuf.Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            Buffer rc = this.parseFramed(input);
            input.checkLastTagWas(0);
            return rc;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    public Buffer parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.parseFramed(new org.fusesource.hawtbuf.Buffer(data));
    }

    public Buffer parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return this.parseUnframed(MessageBufferSupport.readFrame((InputStream)data));
    }

    public static final class Buffer
    implements MessageBuffer<Bean, Buffer>,
    Getter {
        private Bean bean;
        private org.fusesource.hawtbuf.Buffer buffer;
        private int size = -1;
        private int hashCode;

        private Buffer(org.fusesource.hawtbuf.Buffer buffer) {
            this.buffer = buffer;
        }

        private Buffer(Bean bean) {
            this.bean = bean;
        }

        @Override
        public Bean copy() {
            return this.bean().copy();
        }

        @Override
        public Buffer freeze() {
            return this;
        }

        private Bean bean() {
            if (this.bean == null) {
                try {
                    this.bean = new Bean().mergeUnframed(new CodedInputStream(this.buffer));
                    this.bean.frozen = this;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
                }
            }
            return this.bean;
        }

        public String toString() {
            return this.bean().toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            return this.bean().toString(sb, prefix);
        }

        @Override
        public boolean hasClientId() {
            return this.bean().hasClientId();
        }

        @Override
        public UTF8Buffer getClientId() {
            return this.bean().getClientId();
        }

        @Override
        public boolean hasSubscriptions() {
            return this.bean().hasSubscriptions();
        }

        @Override
        public List<TopicPB.Getter> getSubscriptionsList() {
            return this.bean().getSubscriptionsList();
        }

        @Override
        public int getSubscriptionsCount() {
            return this.bean().getSubscriptionsCount();
        }

        @Override
        public TopicPB.Getter getSubscriptions(int index) {
            return this.bean().getSubscriptions(index);
        }

        @Override
        public boolean hasReceivedMessageIds() {
            return this.bean().hasReceivedMessageIds();
        }

        @Override
        public List<Integer> getReceivedMessageIdsList() {
            return this.bean().getReceivedMessageIdsList();
        }

        @Override
        public int getReceivedMessageIdsCount() {
            return this.bean().getReceivedMessageIdsCount();
        }

        @Override
        public Integer getReceivedMessageIds(int index) {
            return this.bean().getReceivedMessageIds(index);
        }

        public org.fusesource.hawtbuf.Buffer toUnframedBuffer() {
            if (this.buffer != null) {
                return this.buffer;
            }
            return MessageBufferSupport.toUnframedBuffer((MessageBuffer)this);
        }

        public org.fusesource.hawtbuf.Buffer toFramedBuffer() {
            return MessageBufferSupport.toFramedBuffer((MessageBuffer)this);
        }

        public byte[] toUnframedByteArray() {
            return this.toUnframedBuffer().toByteArray();
        }

        public byte[] toFramedByteArray() {
            return this.toFramedBuffer().toByteArray();
        }

        public void writeFramed(CodedOutputStream output) throws IOException {
            output.writeRawVarint32(this.serializedSizeUnframed());
            this.writeUnframed(output);
        }

        public void writeFramed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeFramed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(OutputStream output) throws IOException {
            CodedOutputStream codedOutput = new CodedOutputStream(output);
            this.writeUnframed(codedOutput);
            codedOutput.flush();
        }

        public void writeUnframed(CodedOutputStream output) throws IOException {
            if (this.buffer == null) {
                int size = this.serializedSizeUnframed();
                this.buffer = output.getNextBuffer(size);
                CodedOutputStream original = null;
                if (this.buffer == null) {
                    this.buffer = new org.fusesource.hawtbuf.Buffer(new byte[size]);
                    original = output;
                    output = new CodedOutputStream(this.buffer);
                }
                if (this.bean.hasClientId()) {
                    output.writeBytes(1, (org.fusesource.hawtbuf.Buffer)this.bean.getClientId());
                }
                if (this.bean.hasSubscriptions()) {
                    for (TopicPB.Getter i : this.bean.getSubscriptionsList()) {
                        MessageBufferSupport.writeMessage((CodedOutputStream)output, (int)2, (MessageBuffer)i.freeze());
                    }
                }
                if (this.bean.hasReceivedMessageIds()) {
                    Iterator<Object> i$ = this.bean.getReceivedMessageIdsList().iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        output.writeInt32(3, i);
                    }
                }
                if (original != null) {
                    output.checkNoSpaceLeft();
                    output = original;
                    output.writeRawBytes(this.buffer);
                }
            } else {
                output.writeRawBytes(this.buffer);
            }
        }

        public int serializedSizeFramed() {
            int t = this.serializedSizeUnframed();
            return CodedOutputStream.computeRawVarint32Size((int)t) + t;
        }

        public int serializedSizeUnframed() {
            if (this.buffer != null) {
                return this.buffer.length;
            }
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.hasClientId()) {
                this.size += CodedOutputStream.computeBytesSize((int)1, (org.fusesource.hawtbuf.Buffer)this.getClientId());
            }
            if (this.hasSubscriptions()) {
                for (TopicPB.Getter i : this.getSubscriptionsList()) {
                    this.size += MessageBufferSupport.computeMessageSize((int)2, (MessageBuffer)i.freeze());
                }
            }
            if (this.hasReceivedMessageIds()) {
                Iterator<Object> i$ = this.getReceivedMessageIdsList().iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    this.size += CodedOutputStream.computeInt32Size((int)3, (int)i);
                }
            }
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Buffer.class) {
                return false;
            }
            return this.equals((Buffer)obj);
        }

        public boolean equals(Buffer obj) {
            return this.toUnframedBuffer().equals(obj.toUnframedBuffer());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 0x77408060 ^ this.toUnframedBuffer().hashCode();
            }
            return this.hashCode;
        }

        public boolean frozen() {
            return true;
        }
    }

    public static final class Bean
    implements Getter {
        Buffer frozen;
        Bean bean;
        private UTF8Buffer f_clientId = null;
        private List<TopicPB.Getter> f_subscriptions;
        private List<Integer> f_receivedMessageIds;

        public Bean() {
            this.bean = this;
        }

        public Bean(Bean copy) {
            this.bean = copy;
        }

        @Override
        public Bean copy() {
            return new Bean(this.bean);
        }

        public boolean frozen() {
            return this.frozen != null;
        }

        @Override
        public Buffer freeze() {
            if (this.frozen == null) {
                this.frozen = new Buffer(this.bean);
                assert (this.deepFreeze());
            }
            return this.frozen;
        }

        private boolean deepFreeze() {
            this.frozen.serializedSizeUnframed();
            return true;
        }

        private void copyCheck() {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            if (this.bean != this) {
                this.copy(this.bean);
            }
        }

        private void copy(Bean other) {
            this.bean = this;
            this.f_clientId = other.f_clientId;
            this.f_subscriptions = other.f_subscriptions;
            if (this.f_subscriptions != null) {
                this.f_subscriptions = new ArrayList<TopicPB.Getter>(other.f_subscriptions.size());
                for (TopicPB.Getter e : other.f_subscriptions) {
                    this.f_subscriptions.add(e.copy());
                }
            }
            this.f_receivedMessageIds = other.f_receivedMessageIds;
            if (this.f_receivedMessageIds != null && !other.frozen()) {
                this.f_receivedMessageIds = new ArrayList<Integer>(this.f_receivedMessageIds);
            }
        }

        @Override
        public boolean hasClientId() {
            return this.bean.f_clientId != null;
        }

        @Override
        public UTF8Buffer getClientId() {
            return this.bean.f_clientId;
        }

        public Bean setClientId(UTF8Buffer clientId) {
            this.copyCheck();
            this.f_clientId = clientId;
            return this;
        }

        public void clearClientId() {
            this.copyCheck();
            this.f_clientId = null;
        }

        @Override
        public boolean hasSubscriptions() {
            return this.bean.f_subscriptions != null && !this.bean.f_subscriptions.isEmpty();
        }

        @Override
        public List<TopicPB.Getter> getSubscriptionsList() {
            return this.bean.f_subscriptions;
        }

        public List<TopicPB.Getter> createSubscriptionsList() {
            this.copyCheck();
            if (this.f_subscriptions == null) {
                this.f_subscriptions = new ArrayList<TopicPB.Getter>();
            }
            return this.bean.f_subscriptions;
        }

        public Bean setSubscriptionsList(List<TopicPB.Getter> subscriptions) {
            this.copyCheck();
            this.f_subscriptions = subscriptions;
            return this;
        }

        @Override
        public int getSubscriptionsCount() {
            if (this.bean.f_subscriptions == null) {
                return 0;
            }
            return this.bean.f_subscriptions.size();
        }

        @Override
        public TopicPB.Getter getSubscriptions(int index) {
            if (this.bean.f_subscriptions == null) {
                return null;
            }
            return this.bean.f_subscriptions.get(index);
        }

        public Bean setSubscriptions(int index, TopicPB.Getter value) {
            this.createSubscriptionsList().set(index, value);
            return this;
        }

        public Bean addSubscriptions(TopicPB.Getter value) {
            this.createSubscriptionsList().add(value);
            return this;
        }

        public Bean addAllSubscriptions(Iterable<? extends TopicPB.Getter> collection) {
            MessageBufferSupport.addAll(collection, this.createSubscriptionsList());
            return this;
        }

        public void clearSubscriptions() {
            this.copyCheck();
            this.f_subscriptions = null;
        }

        @Override
        public boolean hasReceivedMessageIds() {
            return this.bean.f_receivedMessageIds != null && !this.bean.f_receivedMessageIds.isEmpty();
        }

        @Override
        public List<Integer> getReceivedMessageIdsList() {
            return this.bean.f_receivedMessageIds;
        }

        public List<Integer> createReceivedMessageIdsList() {
            this.copyCheck();
            if (this.f_receivedMessageIds == null) {
                this.f_receivedMessageIds = new ArrayList<Integer>();
            }
            return this.bean.f_receivedMessageIds;
        }

        public Bean setReceivedMessageIdsList(List<Integer> receivedMessageIds) {
            this.copyCheck();
            this.f_receivedMessageIds = receivedMessageIds;
            return this;
        }

        @Override
        public int getReceivedMessageIdsCount() {
            if (this.bean.f_receivedMessageIds == null) {
                return 0;
            }
            return this.bean.f_receivedMessageIds.size();
        }

        @Override
        public Integer getReceivedMessageIds(int index) {
            if (this.bean.f_receivedMessageIds == null) {
                return null;
            }
            return this.bean.f_receivedMessageIds.get(index);
        }

        public Bean setReceivedMessageIds(int index, Integer value) {
            this.createReceivedMessageIdsList().set(index, value);
            return this;
        }

        public Bean addReceivedMessageIds(Integer value) {
            this.createReceivedMessageIdsList().add(value);
            return this;
        }

        public Bean addAllReceivedMessageIds(Iterable<? extends Integer> collection) {
            MessageBufferSupport.addAll(collection, this.createReceivedMessageIdsList());
            return this;
        }

        public void clearReceivedMessageIds() {
            this.copyCheck();
            this.f_receivedMessageIds = null;
        }

        public String toString() {
            return this.toString(new StringBuilder(), "").toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb, String prefix) {
            int i;
            List<Object> l;
            if (this.hasClientId()) {
                sb.append(prefix + "client_id: ");
                sb.append(this.getClientId());
                sb.append("\n");
            }
            if (this.hasSubscriptions()) {
                l = this.getSubscriptionsList();
                for (i = 0; i < l.size(); ++i) {
                    sb.append(prefix + "subscriptions[" + i + "] {\n");
                    ((TopicPB.Getter)l.get(i)).toString(sb, prefix + "  ");
                    sb.append(prefix + "}\n");
                }
            }
            if (this.hasReceivedMessageIds()) {
                l = this.getReceivedMessageIdsList();
                for (i = 0; i < l.size(); ++i) {
                    sb.append(prefix + "received_message_ids[" + i + "]: ");
                    sb.append(l.get(i));
                    sb.append("\n");
                }
            }
            return sb;
        }

        public Bean mergeUnframed(InputStream input) throws IOException {
            return this.mergeUnframed(new CodedInputStream(input));
        }

        public Bean mergeUnframed(CodedInputStream input) throws IOException {
            this.copyCheck();
            int tag;
            block6: while (((tag = input.readTag()) & 7) != 4) {
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        continue block6;
                    }
                    case 10: {
                        this.setClientId(new UTF8Buffer(input.readBytes()));
                        continue block6;
                    }
                    case 18: {
                        this.createSubscriptionsList().add(TopicPB.FACTORY.parseFramed(input));
                        continue block6;
                    }
                    case 24: 
                }
                this.createReceivedMessageIdsList().add(input.readInt32());
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != Bean.class) {
                return false;
            }
            return this.equals((Bean)obj);
        }

        public boolean equals(Bean obj) {
            if (this.hasClientId() ^ obj.hasClientId()) {
                return false;
            }
            if (this.hasClientId() && !this.getClientId().equals((org.fusesource.hawtbuf.Buffer)obj.getClientId())) {
                return false;
            }
            if (this.hasSubscriptions() ^ obj.hasSubscriptions()) {
                return false;
            }
            if (this.hasSubscriptions() && !((Object)this.getSubscriptionsList()).equals(obj.getSubscriptionsList())) {
                return false;
            }
            if (this.hasReceivedMessageIds() ^ obj.hasReceivedMessageIds()) {
                return false;
            }
            return !this.hasReceivedMessageIds() || ((Object)this.getReceivedMessageIdsList()).equals(obj.getReceivedMessageIdsList());
        }

        public int hashCode() {
            int rc = 2066384;
            if (this.hasClientId()) {
                rc ^= 0x39FF9A66 ^ this.getClientId().hashCode();
            }
            if (this.hasSubscriptions()) {
                rc ^= 0xA613FAD6 ^ ((Object)this.getSubscriptionsList()).hashCode();
            }
            if (this.hasReceivedMessageIds()) {
                rc ^= 0x518CAA12 ^ ((Object)this.getReceivedMessageIdsList()).hashCode();
            }
            return rc;
        }

        public Bean mergeFrom(Getter other) {
            this.copyCheck();
            if (other.hasClientId()) {
                this.setClientId(other.getClientId());
            }
            if (other.hasSubscriptions()) {
                for (TopicPB.Getter element : other.getSubscriptionsList()) {
                    this.getSubscriptionsList().add(element.copy());
                }
            }
            if (other.hasReceivedMessageIds()) {
                this.getReceivedMessageIdsList().addAll(other.getReceivedMessageIdsList());
            }
            return this;
        }

        public void clear() {
            this.clearClientId();
            this.clearSubscriptions();
            this.clearReceivedMessageIds();
        }

        public void readExternal(DataInput in) throws IOException {
            assert (this.frozen == null) : "Modification not allowed after object has been fozen.  Try modifying a copy of this object.";
            this.bean = this;
            this.frozen = null;
            int size = in.readInt();
            if (size >= 0) {
                byte[] b = new byte[size];
                in.readFully(b);
                this.f_clientId = new UTF8Buffer(b);
            } else {
                this.f_clientId = null;
            }
            size = in.readShort();
            if (size >= 0) {
                this.f_subscriptions = new ArrayList<TopicPB.Getter>(size);
                for (int i = 0; i < size; ++i) {
                    TopicPB.Bean o = new TopicPB.Bean();
                    o.readExternal(in);
                    this.f_subscriptions.add(o);
                }
            } else {
                this.f_subscriptions = null;
            }
            if ((size = (int)in.readShort()) >= 0) {
                this.f_receivedMessageIds = new ArrayList<Integer>(size);
                for (int i = 0; i < size; ++i) {
                    this.f_receivedMessageIds.add(in.readInt());
                }
            } else {
                this.f_receivedMessageIds = null;
            }
        }

        public void writeExternal(DataOutput out) throws IOException {
            if (this.bean.f_clientId != null) {
                out.writeInt(this.bean.f_clientId.getLength());
                out.write(this.bean.f_clientId.getData(), this.bean.f_clientId.getOffset(), this.bean.f_clientId.getLength());
            } else {
                out.writeInt(-1);
            }
            if (this.bean.f_subscriptions != null) {
                out.writeShort(this.bean.f_subscriptions.size());
                for (TopicPB.Getter getter : this.bean.f_subscriptions) {
                    getter.copy().writeExternal(out);
                }
            } else {
                out.writeShort(-1);
            }
            if (this.bean.f_receivedMessageIds != null) {
                out.writeShort(this.bean.f_receivedMessageIds.size());
                for (Integer n : this.bean.f_receivedMessageIds) {
                    out.writeInt(n);
                }
            } else {
                out.writeShort(-1);
            }
        }
    }

    public static interface Getter
    extends PBMessage<Bean, Buffer> {
        public boolean hasClientId();

        public UTF8Buffer getClientId();

        public boolean hasSubscriptions();

        public List<TopicPB.Getter> getSubscriptionsList();

        public int getSubscriptionsCount();

        public TopicPB.Getter getSubscriptions(int var1);

        public boolean hasReceivedMessageIds();

        public List<Integer> getReceivedMessageIdsList();

        public int getReceivedMessageIdsCount();

        public Integer getReceivedMessageIds(int var1);

        public Bean copy();

        public Buffer freeze();

        public StringBuilder toString(StringBuilder var1, String var2);
    }
}

