/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml.ovf;

import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.ovf.VCloudOperatingSystemSection;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;

public class VCloudOperatingSystemHandler
extends ParseSax.HandlerWithResult<VCloudOperatingSystemSection> {
    private StringBuilder currentText = new StringBuilder();
    protected ReferenceType os;
    protected Integer id;
    protected String info;
    protected String vmwOsType;
    protected String description;
    protected ReferenceType edit;

    @Override
    public VCloudOperatingSystemSection getResult() {
        VCloudOperatingSystemSection system = new VCloudOperatingSystemSection(this.id, this.info, this.description, this.os.getType(), this.os.getHref(), this.vmwOsType, this.edit);
        this.os = null;
        this.id = null;
        this.info = null;
        this.vmwOsType = null;
        this.description = null;
        this.edit = null;
        return system;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("Link")) {
            this.edit = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("OperatingSystemSection")) {
            this.os = Utils.newReferenceType(attributes);
            this.vmwOsType = attributes.get("osType");
            if (attributes.containsKey("id")) {
                this.id = Integer.parseInt(attributes.get("id"));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.endsWith("Info")) {
            this.info = this.currentText.toString().trim();
        } else if (qName.endsWith("Description")) {
            this.description = this.currentText.toString().trim();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

