/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.loaders;

import com.google.common.cache.CacheLoader;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.VCloudClient;

@Singleton
public class OVFLoader
extends CacheLoader<URI, Envelope> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final VCloudClient client;

    @Inject
    OVFLoader(VCloudClient client) {
        this.client = client;
    }

    @Override
    public Envelope load(URI template) {
        return this.client.getVAppTemplateClient().getOvfEnvelopeForVAppTemplate(template);
    }
}

