/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.nat.NatRule;
import org.jclouds.vcloud.domain.network.nat.rules.MappingMode;

public class OneToOneVmRule
implements NatRule {
    private final MappingMode mappingMode;
    @Nullable
    private final String externalIP;
    @Nullable
    private final String vAppScopedVmId;
    private final int vmNicId;

    public OneToOneVmRule(MappingMode mappingMode, @Nullable String externalIp, @Nullable String vAppScopedVmId, int vmNicId) {
        this.mappingMode = Preconditions.checkNotNull(mappingMode, "mappingMode");
        this.externalIP = externalIp;
        this.vAppScopedVmId = vAppScopedVmId;
        this.vmNicId = vmNicId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneToOneVmRule that = (OneToOneVmRule)OneToOneVmRule.class.cast(o);
        return Objects.equal((Object)this.mappingMode, (Object)that.mappingMode) && Objects.equal(this.externalIP, that.externalIP) && Objects.equal(this.vAppScopedVmId, that.vAppScopedVmId) && Objects.equal(this.vmNicId, that.vmNicId);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mappingMode, this.externalIP, this.vAppScopedVmId, this.vmNicId});
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("mappingMode", (Object)this.mappingMode).add("externalIP", this.externalIP).add("vAppScopedVmId", this.vAppScopedVmId).add("vmNicId", this.vmNicId).toString();
    }

    public MappingMode getMappingMode() {
        return this.mappingMode;
    }

    @Override
    @Nullable
    public String getExternalIP() {
        return this.externalIP;
    }

    @Nullable
    public String getVAppScopedVmId() {
        return this.vAppScopedVmId;
    }

    public int getVmNicId() {
        return this.vmNicId;
    }
}

