/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;

@Singleton
public class OrgNameAndTasksListNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultTasksList;

    @Inject
    public OrgNameAndTasksListNameToEndpoint(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap, @Org Supplier<ReferenceType> defaultOrg, @TasksList Supplier<ReferenceType> defaultTasksList) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultOrg;
        this.defaultTasksList = defaultTasksList;
    }

    @Override
    public URI apply(Object from) {
        Iterable orgTasksList = (Iterable)Preconditions.checkNotNull(from, "args");
        Object org = Iterables.get(orgTasksList, 0);
        Object tasksList = Iterables.get(orgTasksList, 1);
        if (org == null && tasksList == null) {
            return this.defaultTasksList.get().getHref();
        }
        if (org == null) {
            org = this.defaultOrg.get().getName();
        }
        try {
            Map<String, ReferenceType> tasksLists = Preconditions.checkNotNull(this.orgMap.get().get(org)).getTasksLists();
            return tasksList == null ? Iterables.getLast(tasksLists.values()).getHref() : tasksLists.get(tasksList).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + tasksList + " not found in " + this.orgMap.get());
        }
    }
}

