/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;
import org.jclouds.trmk.vcloud_0_8.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultTasksListForOrg
implements Function<ReferenceType, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<Map<String, ? extends Org>> nameToOrg;

    @Inject
    public DefaultTasksListForOrg(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @TasksList Predicate<ReferenceType> defaultSelector, Supplier<Map<String, ? extends Org>> nameToOrg) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.taskslist", Preconditions.checkNotNull(defaultSelector, "defaultSelector"));
        this.nameToOrg = Preconditions.checkNotNull(nameToOrg, "nameToOrg");
    }

    @Override
    public ReferenceType apply(ReferenceType defaultOrg) {
        Org org = this.nameToOrg.get().get(defaultOrg.getName());
        Preconditions.checkState(org != null, "could not retrieve Org at %s", defaultOrg);
        return this.selector.apply((Iterable<ReferenceType>)org.getTasksLists().values());
    }
}

