/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.xml.MessageHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReceiveMessageResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<Message>> {
    private final MessageHandler messageHandler;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();
    private boolean inMessages;

    @Inject
    public ReceiveMessageResponseHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    public FluentIterable<Message> getResult() {
        return FluentIterable.from(this.messages.build());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "ReceiveMessageResult")) {
            this.inMessages = true;
        }
        if (this.inMessages) {
            this.messageHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "ReceiveMessageResult")) {
            this.inMessages = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "Message")) {
            this.messages.add((Object)this.messageHandler.getResult());
        } else if (this.inMessages) {
            this.messageHandler.endElement(uri, name, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inMessages) {
            this.messageHandler.characters(ch, start, length);
        }
    }
}

