/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;

public class QueueAttributes {
    protected final long approximateNumberOfMessages;
    protected final long approximateNumberOfMessagesNotVisible;
    protected final int visibilityTimeout;
    protected final Date createdTimestamp;
    protected final Date lastModifiedTimestamp;
    protected final long approximateNumberOfMessagesDelayed;
    protected final Optional<String> rawPolicy;
    protected final int maximumMessageSize;
    protected final int messageRetentionPeriod;
    protected final String queueArn;
    protected int delaySeconds;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromQueueAttributes(this);
    }

    protected QueueAttributes(String queueArn, long approximateNumberOfMessages, long approximateNumberOfMessagesNotVisible, long approximateNumberOfMessagesDelayed, int visibilityTimeout, Date createdTimestamp, Date lastModifiedTimestamp, Optional<String> rawPolicy, int maximumMessageSize, int messageRetentionPeriod, int delaySeconds) {
        this.queueArn = Preconditions.checkNotNull(queueArn, "queueArn");
        this.approximateNumberOfMessages = approximateNumberOfMessages;
        this.approximateNumberOfMessagesNotVisible = approximateNumberOfMessagesNotVisible;
        this.approximateNumberOfMessagesDelayed = approximateNumberOfMessagesDelayed;
        this.visibilityTimeout = visibilityTimeout;
        this.createdTimestamp = Preconditions.checkNotNull(createdTimestamp, "createdTimestamp of %s", queueArn);
        this.lastModifiedTimestamp = Preconditions.checkNotNull(lastModifiedTimestamp, "lastModifiedTimestamp of %s", queueArn);
        this.rawPolicy = Preconditions.checkNotNull(rawPolicy, "rawPolicy of %s", queueArn);
        this.maximumMessageSize = maximumMessageSize;
        this.messageRetentionPeriod = messageRetentionPeriod;
        this.delaySeconds = delaySeconds;
    }

    public String getQueueArn() {
        return this.queueArn;
    }

    public long getApproximateNumberOfMessages() {
        return this.approximateNumberOfMessages;
    }

    public long getApproximateNumberOfMessagesNotVisible() {
        return this.approximateNumberOfMessagesNotVisible;
    }

    public long getApproximateNumberOfMessagesDelayed() {
        return this.approximateNumberOfMessagesDelayed;
    }

    public int getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Date getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public Optional<String> getRawPolicy() {
        return this.rawPolicy;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public int getMessageRetentionPeriod() {
        return this.messageRetentionPeriod;
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public int hashCode() {
        return Objects.hashCode(this.queueArn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueueAttributes other = (QueueAttributes)obj;
        return Objects.equal(this.queueArn, other.queueArn);
    }

    public String toString() {
        return Objects.toStringHelper(this).omitNullValues().add("queueArn", this.queueArn).add("approximateNumberOfMessages", this.approximateNumberOfMessages).add("approximateNumberOfMessagesNotVisible", this.approximateNumberOfMessagesNotVisible).add("approximateNumberOfMessagesDelayed", this.approximateNumberOfMessagesDelayed).add("visibilityTimeout", this.visibilityTimeout).add("createdTimestamp", this.createdTimestamp).add("lastModifiedTimestamp", this.lastModifiedTimestamp).add("rawPolicy", this.rawPolicy.orNull()).add("maximumMessageSize", this.maximumMessageSize).add("messageRetentionPeriod", this.messageRetentionPeriod).add("delaySeconds", this.delaySeconds).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String queueArn;
        protected long approximateNumberOfMessages;
        protected long approximateNumberOfMessagesNotVisible;
        protected long approximateNumberOfMessagesDelayed;
        protected int visibilityTimeout;
        protected Date createdTimestamp;
        protected Date lastModifiedTimestamp;
        protected Optional<String> rawPolicy = Optional.absent();
        protected int maximumMessageSize;
        protected int messageRetentionPeriod;
        protected int delaySeconds;

        protected abstract T self();

        public T queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this.self();
        }

        public T approximateNumberOfMessages(long approximateNumberOfMessages) {
            this.approximateNumberOfMessages = approximateNumberOfMessages;
            return this.self();
        }

        public T approximateNumberOfMessagesNotVisible(long approximateNumberOfMessagesNotVisible) {
            this.approximateNumberOfMessagesNotVisible = approximateNumberOfMessagesNotVisible;
            return this.self();
        }

        public T approximateNumberOfMessagesDelayed(long approximateNumberOfMessagesDelayed) {
            this.approximateNumberOfMessagesDelayed = approximateNumberOfMessagesDelayed;
            return this.self();
        }

        public T visibilityTimeout(int visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this.self();
        }

        public T createdTimestamp(Date createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this.self();
        }

        public T lastModifiedTimestamp(Date lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this.self();
        }

        public T rawPolicy(String rawPolicy) {
            this.rawPolicy = Optional.fromNullable(rawPolicy);
            return this.self();
        }

        public T maximumMessageSize(int maximumMessageSize) {
            this.maximumMessageSize = maximumMessageSize;
            return this.self();
        }

        public T messageRetentionPeriod(int messageRetentionPeriod) {
            this.messageRetentionPeriod = messageRetentionPeriod;
            return this.self();
        }

        public T delaySeconds(int delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this.self();
        }

        public QueueAttributes build() {
            return new QueueAttributes(this.queueArn, this.approximateNumberOfMessages, this.approximateNumberOfMessagesNotVisible, this.approximateNumberOfMessagesDelayed, this.visibilityTimeout, this.createdTimestamp, this.lastModifiedTimestamp, this.rawPolicy, this.maximumMessageSize, this.messageRetentionPeriod, this.delaySeconds);
        }

        public T fromQueueAttributes(QueueAttributes in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.queueArn(in.queueArn)).approximateNumberOfMessages(in.approximateNumberOfMessages)).approximateNumberOfMessagesNotVisible(in.approximateNumberOfMessagesNotVisible)).approximateNumberOfMessagesDelayed(in.approximateNumberOfMessagesDelayed)).visibilityTimeout(in.visibilityTimeout)).createdTimestamp(in.createdTimestamp)).lastModifiedTimestamp(in.lastModifiedTimestamp)).rawPolicy(in.rawPolicy.orNull())).maximumMessageSize(in.maximumMessageSize)).messageRetentionPeriod(in.messageRetentionPeriod)).delaySeconds(in.delaySeconds);
        }
    }
}

