/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.NewZone;
import org.jclouds.route53.domain.Zone;
import org.jclouds.route53.domain.ZoneAndNameServers;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.functions.ZonesToPagedIterable;
import org.jclouds.route53.xml.ChangeHandler;
import org.jclouds.route53.xml.CreateHostedZoneResponseHandler;
import org.jclouds.route53.xml.GetHostedZoneResponseHandler;
import org.jclouds.route53.xml.ListHostedZonesResponseHandler;

@RequestFilters(value={RestAuthentication.class})
@VirtualHost
@Path(value="/{jclouds.api-version}")
public interface ZoneAsyncApi {
    @Named(value="CreateHostedZone")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/hostedzone")
    @Payload(value="<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>{name}</Name><CallerReference>{callerReference}</CallerReference></CreateHostedZoneRequest>")
    @XMLResponseParser(value=CreateHostedZoneResponseHandler.class)
    public ListenableFuture<NewZone> createWithReference(@PayloadParam(value="name") String var1, @PayloadParam(value="callerReference") String var2);

    @Named(value="CreateHostedZone")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/hostedzone")
    @Payload(value="<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><Name>{name}</Name><CallerReference>{callerReference}</CallerReference><HostedZoneConfig><Comment>{comment}</Comment></HostedZoneConfig></CreateHostedZoneRequest>")
    @XMLResponseParser(value=CreateHostedZoneResponseHandler.class)
    public ListenableFuture<NewZone> createWithReferenceAndComment(@PayloadParam(value="name") String var1, @PayloadParam(value="callerReference") String var2, @PayloadParam(value="comment") String var3);

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    @Transform(value=ZonesToPagedIterable.class)
    public ListenableFuture<PagedIterable<Zone>> list();

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    public ListenableFuture<IterableWithMarker<Zone>> listFirstPage();

    @Named(value="ListHostedZones")
    @GET
    @Path(value="/hostedzone")
    @XMLResponseParser(value=ListHostedZonesResponseHandler.class)
    public ListenableFuture<IterableWithMarker<Zone>> listAt(@QueryParam(value="marker") String var1);

    @Named(value="GetHostedZone")
    @GET
    @Path(value="/hostedzone/{zoneId}")
    @XMLResponseParser(value=GetHostedZoneResponseHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ZoneAndNameServers> get(@PathParam(value="zoneId") String var1);

    @Named(value="DeleteHostedZone")
    @DELETE
    @Path(value="/hostedzone/{zoneId}")
    @XMLResponseParser(value=ChangeHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Change> delete(@PathParam(value="zoneId") String var1);
}

