/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.options;

import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateContainerOptions
extends BaseHttpRequestOptions {
    public static final CreateContainerOptions NONE = new CreateContainerOptions();

    public CreateContainerOptions withMetadata(Map<String, String> metadata) {
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (entry.getKey().startsWith("X-Container-Meta-")) {
                this.headers.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.headers.put("X-Container-Meta-" + entry.getKey(), entry.getValue());
        }
        return this;
    }

    public CreateContainerOptions withPublicAccess() {
        this.headers.put("X-Container-Read", ".r:*,.rlistings");
        return this;
    }

    public static class Builder {
        public static CreateContainerOptions withPublicAccess() {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.withPublicAccess();
        }

        public static CreateContainerOptions withMetadata(Map<String, String> metadata) {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.withMetadata(metadata);
        }
    }
}

