/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.openstack.nova.NovaAsyncClient;
import org.jclouds.openstack.nova.NovaClient;
import org.jclouds.openstack.nova.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.config.NovaRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class NovaApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<NovaClient, NovaAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<NovaClient, NovaAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public NovaApiMetadata() {
        this(new Builder());
    }

    protected NovaApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(NovaClient.class, NovaAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("nova").name("OpenStack Nova Pre-Diablo API").identityName("accessKey").credentialName("secretKey").documentation(URI.create("http://api.openstack.org/")).version("1.1").defaultEndpoint("http://localhost:5000").defaultProperties(NovaApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class))).defaultModules(ImmutableSet.of(NovaRestClientModule.class, NovaComputeServiceContextModule.class));
        }

        @Override
        public NovaApiMetadata build() {
            return new NovaApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

