/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Role;

public class User
extends ForwardingSet<Role> {
    private final String id;
    private final String name;
    private final Set<Role> roles;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUser(this);
    }

    @ConstructorProperties(value={"id", "name", "roles"})
    protected User(String id, String name, @Nullable Set<Role> roles) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.roles = roles == null ? ImmutableSet.of() : ImmutableSet.copyOf(roles);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Set<Role> getRoles() {
        return this.roles;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.roles);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)User.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.roles, that.roles);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("roles", this.roles);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    protected Set<Role> delegate() {
        return this.roles;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected ImmutableSet.Builder<Role> roles = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T role(Role role) {
            this.roles.add((Object)role);
            return this.self();
        }

        public T roles(Iterable<Role> roles) {
            this.roles.addAll((Iterable)roles);
            return this.self();
        }

        @Deprecated
        public T roles(Role ... in) {
            return this.roles(ImmutableSet.copyOf(in));
        }

        public User build() {
            return new User(this.id, this.name, (Set<Role>)((Object)this.roles.build()));
        }

        public T fromUser(User in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).roles(in);
        }
    }
}

