/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.Item;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.VNC;
import org.jclouds.javax.annotation.Nullable;

public class Server
extends Item {
    protected final int cpu;
    protected final Integer smp;
    protected final int mem;
    protected final boolean persistent;
    @Nullable
    protected final Map<String, Device> devices;
    protected final Set<String> bootDeviceIds;
    protected final List<NIC> nics;
    protected final VNC vnc;

    public Server(@Nullable String uuid, String name, int cpu, @Nullable Integer smp, int mem, boolean persistent, Map<String, ? extends Device> devices, Iterable<String> bootDeviceIds, Iterable<String> tags, Map<String, String> userMetadata, Iterable<NIC> nics, VNC vnc) {
        super(uuid, name, tags, userMetadata);
        this.cpu = cpu;
        this.smp = smp;
        this.mem = mem;
        this.persistent = persistent;
        this.devices = ImmutableMap.copyOf(Preconditions.checkNotNull(devices, "devices"));
        this.bootDeviceIds = ImmutableSet.copyOf(Preconditions.checkNotNull(bootDeviceIds, "bootDeviceIds"));
        this.nics = ImmutableList.copyOf(Preconditions.checkNotNull(nics, "nics"));
        this.vnc = Preconditions.checkNotNull(vnc, "vnc");
    }

    public int getCpu() {
        return this.cpu;
    }

    public Integer getSmp() {
        return this.smp;
    }

    public int getMem() {
        return this.mem;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Map<String, Device> getDevices() {
        return this.devices;
    }

    public Set<String> getBootDeviceIds() {
        return this.bootDeviceIds;
    }

    public List<NIC> getNics() {
        return this.nics;
    }

    public VNC getVnc() {
        return this.vnc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bootDeviceIds == null ? 0 : ((Object)this.bootDeviceIds).hashCode());
        result = 31 * result + this.cpu;
        result = 31 * result + (this.devices == null ? 0 : ((Object)this.devices).hashCode());
        result = 31 * result + this.mem;
        result = 31 * result + (this.nics == null ? 0 : ((Object)this.nics).hashCode());
        result = 31 * result + (this.persistent ? 1231 : 1237);
        result = 31 * result + (this.smp == null ? 0 : this.smp.hashCode());
        result = 31 * result + (this.vnc == null ? 0 : this.vnc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (this.bootDeviceIds == null ? other.bootDeviceIds != null : !((Object)this.bootDeviceIds).equals(other.bootDeviceIds)) {
            return false;
        }
        if (this.cpu != other.cpu) {
            return false;
        }
        if (this.devices == null ? other.devices != null : !((Object)this.devices).equals(other.devices)) {
            return false;
        }
        if (this.mem != other.mem) {
            return false;
        }
        if (this.nics == null ? other.nics != null : !((Object)this.nics).equals(other.nics)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        if (this.smp == null ? other.smp != null : !this.smp.equals(other.smp)) {
            return false;
        }
        return !(this.vnc == null ? other.vnc != null : !this.vnc.equals(other.vnc));
    }

    @Override
    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + ", cpu=" + this.cpu + ", smp=" + this.smp + ", mem=" + this.mem + ", persistent=" + this.persistent + ", devices=" + this.devices + ", bootDeviceIds=" + this.bootDeviceIds + ", nics=" + this.nics + ", vnc=" + this.vnc + "]";
    }

    public static class Builder
    extends Item.Builder {
        protected int cpu;
        protected Integer smp;
        protected int mem;
        protected boolean persistent;
        protected Map<String, ? extends Device> devices = ImmutableMap.of();
        protected Set<String> bootDeviceIds = ImmutableSet.of();
        protected List<NIC> nics = ImmutableList.of();
        protected VNC vnc;

        public Builder cpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder smp(Integer smp) {
            this.smp = smp;
            return this;
        }

        public Builder mem(int mem) {
            this.mem = mem;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder devices(Map<String, ? extends Device> devices) {
            this.devices = ImmutableMap.copyOf(Preconditions.checkNotNull(devices, "devices"));
            return this;
        }

        public Builder bootDeviceIds(Iterable<String> bootDeviceIds) {
            this.bootDeviceIds = ImmutableSet.copyOf(Preconditions.checkNotNull(bootDeviceIds, "bootDeviceIds"));
            return this;
        }

        public Builder nics(Iterable<NIC> nics) {
            this.nics = ImmutableList.copyOf(Preconditions.checkNotNull(nics, "nics"));
            return this;
        }

        public Builder vnc(VNC vnc) {
            this.vnc = vnc;
            return this;
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags(tags));
        }

        @Override
        public Builder userMetadata(Map<String, String> userMetadata) {
            return (Builder)Builder.class.cast(super.userMetadata(userMetadata));
        }

        @Override
        public Server build() {
            return new Server(this.uuid, this.name, this.cpu, this.smp, this.mem, this.persistent, this.devices, this.bootDeviceIds, this.tags, this.userMetadata, this.nics, this.vnc);
        }

        public static Builder fromServer(Server in) {
            return ((Builder)((Builder)new Builder().uuid(in.getUuid()).name(in.getName()).cpu(in.getCpu()).mem(in.getMem()).persistent(in.isPersistent()).devices(in.getDevices()).bootDeviceIds(in.getBootDeviceIds()).tags(in.getTags())).userMetadata((Map)in.getUserMetadata())).nics(in.getNics()).vnc(in.getVnc());
        }
    }
}

