/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class DescribeImagesOptions
extends BaseEC2RequestOptions {
    public static final DescribeImagesOptions NONE = new DescribeImagesOptions();

    public DescribeImagesOptions executableBy(String identityId) {
        this.formParameters.put("ExecutableBy", Preconditions.checkNotNull(identityId, "identityId"));
        return this;
    }

    public String getExecutableBy() {
        return this.getFirstFormOrNull("ExecutableBy");
    }

    public DescribeImagesOptions imageIds(String ... imageIds) {
        this.indexFormValuesWithPrefix("ImageId", imageIds);
        return this;
    }

    public DescribeImagesOptions imageIds(Iterable<String> imageIds) {
        this.indexFormValuesWithPrefix("ImageId", imageIds);
        return this;
    }

    public Set<String> getImageIds() {
        return this.getFormValuesWithKeysPrefixedBy("ImageId.");
    }

    public DescribeImagesOptions ownedBy(String ... owners) {
        this.indexFormValuesWithPrefix("Owner", owners);
        return this;
    }

    public Set<String> getOwners() {
        return this.getFormValuesWithKeysPrefixedBy("Owner.");
    }

    public static class Builder {
        public static DescribeImagesOptions executableBy(String identityId) {
            DescribeImagesOptions options = new DescribeImagesOptions();
            return options.executableBy(identityId);
        }

        public static DescribeImagesOptions imageIds(String ... imageIds) {
            DescribeImagesOptions options = new DescribeImagesOptions();
            return options.imageIds(imageIds);
        }

        public static DescribeImagesOptions ownedBy(String ... owners) {
            DescribeImagesOptions options = new DescribeImagesOptions();
            return options.ownedBy(owners);
        }
    }
}

