/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.util.Throwables2;

public class EC2TemplateBuilderImpl
extends TemplateBuilderImpl {
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> lazyImageCache;
    final Provider<Image> lazyImageProvider = new Provider<Image>(){

        @Override
        public Image get() {
            if (EC2TemplateBuilderImpl.this.imageId != null) {
                String[] regionName = EC2TemplateBuilderImpl.this.imageId.split("/");
                Preconditions.checkArgument(regionName.length == 2, "amazon image ids must include the region ( ex. us-east-1/ami-7ea24a17 ) you specified: " + EC2TemplateBuilderImpl.this.imageId);
                RegionAndName key = new RegionAndName(regionName[0], regionName[1]);
                try {
                    return (Image)((LoadingCache)EC2TemplateBuilderImpl.this.lazyImageCache.get()).get(key);
                }
                catch (ExecutionException e) {
                    throw new NoSuchElementException(String.format("could not get imageId(%s/%s)", key.getRegion(), key.getName()));
                }
                catch (UncheckedExecutionException e) {
                    IllegalArgumentException e2 = Throwables2.getFirstThrowableOfType(e, IllegalArgumentException.class);
                    if (e2 != null && e2.getMessage() != null && e2.getMessage().contains("not present in")) {
                        throw new NoSuchElementException(String.format("imageId(%s/%s) not found", key.getRegion(), key.getName()));
                    }
                    throw new NoSuchElementException(String.format("could not get imageId(%s/%s)", key.getRegion(), key.getName()));
                }
                catch (CacheLoader.InvalidCacheLoadException nex) {
                    throw new NoSuchElementException(String.format("imageId(%s/%s) not found", key.getRegion(), key.getName()));
                }
            }
            return null;
        }
    };

    @Inject
    protected EC2TemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, Supplier<Location> defaultLocation, @Named(value="DEFAULT") Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider, Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap) {
        super(locations, images, sizes, defaultLocation, optionsProvider, defaultTemplateProvider);
        this.lazyImageCache = imageMap;
    }

    @Override
    protected Image resolveImage(Hardware size, Iterable<? extends Image> supportedImages) {
        try {
            return super.resolveImage(size, supportedImages);
        }
        catch (NoSuchElementException e) {
            Image returnVal = this.lazyImageProvider.get();
            if (returnVal != null) {
                return returnVal;
            }
            throw e;
        }
    }

    @Override
    protected Set<? extends Image> getImages() {
        if (this.imageId != null) {
            Image image = this.lazyImageProvider.get();
            return ImmutableSet.of(image);
        }
        return (Set)this.images.get();
    }
}

