/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.xml.InstanceHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstancesHandler
extends ParseSax.HandlerWithResult<Set<? extends Instance>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Instance> instances = Sets.newLinkedHashSet();
    private final InstanceHandler instanceHandler;

    @Inject
    public InstancesHandler(InstanceHandler locationHandler) {
        this.instanceHandler = locationHandler;
    }

    @Override
    public Set<? extends Instance> getResult() {
        return this.instances;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.instanceHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.instanceHandler.endElement(uri, localName, qName);
        if (qName.equals("instance") && this.currentText.toString().trim().equals("")) {
            this.instances.add(this.instanceHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.instanceHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

