/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.xml.HardwareProfileHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HardwareProfilesHandler
extends ParseSax.HandlerWithResult<Set<? extends HardwareProfile>> {
    private StringBuilder currentText = new StringBuilder();
    private Set<HardwareProfile> hardwareProfiles = Sets.newLinkedHashSet();
    private final HardwareProfileHandler hardwareProfileHandler;

    @Inject
    public HardwareProfilesHandler(HardwareProfileHandler locationHandler) {
        this.hardwareProfileHandler = locationHandler;
    }

    @Override
    public Set<? extends HardwareProfile> getResult() {
        return this.hardwareProfiles;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.hardwareProfileHandler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.hardwareProfileHandler.endElement(uri, localName, qName);
        if (qName.equals("hardware_profile") && this.currentText.toString().trim().equals("")) {
            this.hardwareProfiles.add(this.hardwareProfileHandler.getResult());
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.hardwareProfileHandler.characters(ch, start, length);
        this.currentText.append(ch, start, length);
    }
}

