/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;

@Singleton
public class RealmToLocation
implements Function<Realm, Location> {
    private final String providerName;
    private final Supplier<URI> endpoint;
    private final Set<String> isoCodes;

    @Inject
    public RealmToLocation(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider Supplier<URI> endpoint) {
        this.providerName = Preconditions.checkNotNull(providerName, "providerName");
        this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
        this.isoCodes = Preconditions.checkNotNull(isoCodes, "isoCodes");
    }

    @Override
    public Location apply(Realm from) {
        return new LocationBuilder().scope(LocationScope.ZONE).id(from.getHref().toASCIIString()).description(from.getName()).parent(new LocationBuilder().scope(LocationScope.PROVIDER).iso3166Codes(this.isoCodes).id(this.providerName).description(this.endpoint.get().toASCIIString()).parent(null).build()).build();
    }
}

