/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.predicates.internal.TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse;
import org.jclouds.compute.strategy.GetImageStrategy;

public class AtomicImageDeleted
extends TrueIfNullOrDeletedRefreshAndDoubleCheckOnFalse<Image.Status, Image> {
    private final GetImageStrategy client;

    @Inject
    public AtomicImageDeleted(GetImageStrategy client) {
        super(Image.Status.DELETED);
        this.client = Preconditions.checkNotNull(client, "client");
    }

    @Override
    protected Image refreshOrNull(Image resource) {
        if (resource == null || resource.getId() == null) {
            return null;
        }
        return this.client.getImage(resource.getId());
    }
}

