/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;

@Beta
public class AdvanceUntilEmptyIterable<E>
extends FluentIterable<FluentIterable<E>> {
    private final AdvanceUntilEmptyIterator<E> iterator;

    public static <E> AdvanceUntilEmptyIterable<E> create(Supplier<FluentIterable<E>> nextIterable) {
        return new AdvanceUntilEmptyIterable<E>(nextIterable);
    }

    protected AdvanceUntilEmptyIterable(Supplier<FluentIterable<E>> nextIterable) {
        this.iterator = new AdvanceUntilEmptyIterator<E>(Preconditions.checkNotNull(nextIterable, "next iterable"));
    }

    @Override
    public Iterator<FluentIterable<E>> iterator() {
        return this.iterator;
    }

    public FluentIterable<E> concat() {
        final Iterator<FluentIterable<E>> iterator = this.iterator();
        final UnmodifiableIterator unmodifiable = new UnmodifiableIterator<Iterator<E>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<E> next() {
                return ((FluentIterable)iterator.next()).iterator();
            }
        };
        return new FluentIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.concat(unmodifiable);
            }
        };
    }

    static class AdvanceUntilEmptyIterator<E>
    extends AbstractIterator<FluentIterable<E>> {
        private final Supplier<FluentIterable<E>> nextIterable;
        private transient FluentIterable<E> current;
        private transient boolean unread = true;

        AdvanceUntilEmptyIterator(Supplier<FluentIterable<E>> nextIterable) {
            this.nextIterable = Preconditions.checkNotNull(nextIterable, "next iterable");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FluentIterable<E> computeNext() {
            if (this.unread) {
                try {
                    this.current = this.nextIterable.get();
                    FluentIterable<E> fluentIterable = this.current;
                    return fluentIterable;
                }
                finally {
                    this.unread = false;
                }
            }
            if (this.current.size() > 0) {
                this.current = this.nextIterable.get();
                return this.current;
            }
            return (FluentIterable)this.endOfData();
        }

        public int hashCode() {
            return Objects.hashCode(this.current, this.unread);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvanceUntilEmptyIterator other = (AdvanceUntilEmptyIterator)AdvanceUntilEmptyIterator.class.cast(obj);
            return Objects.equal(this.current, other.current) && Objects.equal(this.unread, other.unread);
        }

        public String toString() {
            return Objects.toStringHelper("").omitNullValues().add("current", this.current).add("unread", this.unread).toString();
        }
    }
}

