/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.ApiKeyPair;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.options.ListAccountsOptions;
import org.jclouds.compute.ComputeServiceContext;

public class ApiKeyPairs {
    public static ApiKeyPair loginToEndpointAsUsernameInDomainWithPasswordAndReturnApiKeyPair(URI endpoint, String username, String password, String domain) {
        ComputeServiceContext context = null;
        try {
            Properties overrides = new Properties();
            overrides.put("jclouds.trust-all-certs", "true");
            overrides.put("jclouds.relax-hostname", "true");
            overrides.put("jclouds.cloudstack.credential-type", "passwordCredentials");
            context = ContextBuilder.newBuilder(new CloudStackApiMetadata()).endpoint(Preconditions.checkNotNull(endpoint, "endpoint").toASCIIString()).credentials(String.format("%s/%s", Preconditions.checkNotNull(domain, "domain"), Preconditions.checkNotNull(username, "username")), password).overrides(overrides).build(CloudStackContext.class);
            CloudStackClient client = context.getProviderSpecificContext().getApi();
            Set<Account> listOfAccounts = client.getAccountClient().listAccounts(new ListAccountsOptions[0]);
            domain = domain.equals("") || domain.equals("/") ? "ROOT" : domain;
            for (Account account : listOfAccounts) {
                for (User user : account.getUsers()) {
                    if (!user.getName().equals(username) || !user.getDomain().equals(domain)) continue;
                    ApiKeyPair apiKeyPair = ((ApiKeyPair.Builder)((ApiKeyPair.Builder)ApiKeyPair.builder().apiKey(user.getApiKey())).secretKey(user.getSecretKey())).build();
                    return apiKeyPair;
                }
            }
            throw new NoSuchElementException("Unable to find API keypair for user " + username);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

