/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateExtraction;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;

@Singleton
public class ParseTypedAsyncJob
implements Function<AsyncJob<Map<String, JsonBall>>, AsyncJob<?>> {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.cloudstack.jobresult-type-map")
    @VisibleForTesting
    Map<String, Class<?>> typeMap = ImmutableMap.builder().put("user", User.class).put("account", Account.class).put("securitygroup", SecurityGroup.class).put("portforwardingrule", PortForwardingRule.class).put("ipforwardingrule", IPForwardingRule.class).put("firewallrule", FirewallRule.class).put("network", Network.class).put("ipaddress", PublicIPAddress.class).put("virtualmachine", VirtualMachine.class).put("loadbalancer", LoadBalancerRule.class).put("snapshot", Snapshot.class).put("template", Template.class).put("volume", Volume.class).build();
    private final Json json;

    @Inject
    public ParseTypedAsyncJob(Json json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public AsyncJob<?> apply(AsyncJob<Map<String, JsonBall>> toParse) {
        AsyncJob result = toParse;
        if (toParse.getResult() != null) {
            if (toParse.getResult().size() == 1) {
                AsyncJob.Builder<?, Object> builder = AsyncJob.Builder.fromAsyncJobUntyped(toParse);
                if (toParse.getResult().containsKey("success")) {
                    builder.result(null);
                } else {
                    Map.Entry<String, JsonBall> entry = Iterables.get(toParse.getResult().entrySet(), 0);
                    if ("template".equals(entry.getKey())) {
                        Template template = this.json.fromJson(entry.getValue().toString(), Template.class);
                        TemplateExtraction templateExtraction = this.json.fromJson(entry.getValue().toString(), TemplateExtraction.class);
                        boolean isTemplate = Strings.isNullOrEmpty(templateExtraction.getState());
                        builder.result(isTemplate ? template : templateExtraction);
                    } else if (this.typeMap.containsKey(entry.getKey())) {
                        builder.result(this.json.fromJson(entry.getValue().toString(), this.typeMap.get(entry.getKey())));
                    } else {
                        this.logger.warn("type key %s not configured.  please override default for Map<String, Class<?>> bound to name jclouds.cloudstack.jobresult-type-map", entry.getKey());
                        builder.result(entry.getValue().toString());
                    }
                }
                result = builder.build();
            } else if (toParse.getResult().containsKey("errorcode")) {
                AsyncJob.Builder<?, Object> builder = AsyncJob.Builder.fromAsyncJobUntyped(toParse);
                builder.result(null);
                builder.error(((AsyncJobError.Builder)((AsyncJobError.Builder)AsyncJobError.builder().errorCode(AsyncJobError.ErrorCode.fromValue(((JsonBall)((Map)toParse.getResult()).get("errorcode")).toString()))).errorText(((Map)toParse.getResult()).containsKey("errortext") ? ((JsonBall)((Map)toParse.getResult()).get("errortext")).toString().replace("\"", "") : null)).build());
                result = builder.build();
            } else if (toParse.getResult().size() > 1) {
                this.logger.warn("unexpected size of async job result; expecting a map with a single element", toParse.getResult());
            }
        }
        return result;
    }
}

