/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.javax.annotation.Nullable;

public class VirtualMachine {
    private final String id;
    private final String account;
    private final long cpuCount;
    private final long cpuSpeed;
    private final String cpuUsed;
    private final String displayName;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final boolean usesVirtualNetwork;
    private final String group;
    private final String groupId;
    private final String guestOSId;
    private final boolean HAEnabled;
    private final String hostId;
    private final String hostname;
    private final String IPAddress;
    private final String ISODisplayText;
    private final String ISOId;
    private final String ISOName;
    private final String jobId;
    private final Integer jobStatus;
    private final long memory;
    private final String name;
    private final Long networkKbsRead;
    private final Long networkKbsWrite;
    private final String password;
    private final boolean passwordEnabled;
    private final String publicIP;
    private final String publicIPId;
    private final String rootDeviceId;
    private final String rootDeviceType;
    private final String serviceOfferingId;
    private final String serviceOfferingName;
    private final State state;
    private final String templateDisplayText;
    private final String templateId;
    private final String templateName;
    private final String zoneId;
    private final String zoneName;
    private final Set<NIC> nics;
    private final String hypervisor;
    private final Set<SecurityGroup> securityGroups;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVirtualMachine(this);
    }

    @ConstructorProperties(value={"id", "account", "cpunumber", "cpuspeed", "cpuused", "displayname", "created", "domain", "domainid", "forvirtualnetwork", "group", "groupid", "guestosid", "haenable", "hostid", "hostname", "ipaddress", "isodisplaytext", "isoid", "isoname", "jobid", "jobstatus", "memory", "name", "networkkbsread", "networkkbswrite", "password", "passwordenabled", "publicip", "publicipid", "rootdeviceid", "rootdevicetype", "serviceofferingid", "serviceofferingname", "state", "templatedisplaytext", "templateid", "templatename", "zoneid", "zonename", "nic", "hypervisor", "securitygroup"})
    protected VirtualMachine(String id, @Nullable String account, long cpuCount, long cpuSpeed, @Nullable String cpuUsed, @Nullable String displayName, @Nullable Date created, @Nullable String domain, @Nullable String domainId, boolean usesVirtualNetwork, @Nullable String group, @Nullable String groupId, @Nullable String guestOSId, boolean HAEnabled, @Nullable String hostId, @Nullable String hostname, String IPAddress2, String ISODisplayText, @Nullable String ISOId, @Nullable String ISOName, @Nullable String jobId, @Nullable Integer jobStatus, long memory, @Nullable String name, @Nullable Long networkKbsRead, @Nullable Long networkKbsWrite, @Nullable String password, boolean passwordEnabled, @Nullable String publicIP, @Nullable String publicIPId, @Nullable String rootDeviceId, @Nullable String rootDeviceType, @Nullable String serviceOfferingId, @Nullable String serviceOfferingName, @Nullable State state, @Nullable String templateDisplayText, @Nullable String templateId, @Nullable String templateName, @Nullable String zoneId, @Nullable String zoneName, @Nullable Set<NIC> nics, @Nullable String hypervisor, @Nullable Set<SecurityGroup> securityGroups) {
        Preconditions.checkArgument(Strings.isNullOrEmpty(cpuUsed) || cpuUsed.matches("^[0-9\\.\\-]+%$"), "cpuUsed value should be a decimal number followed by %");
        this.id = Preconditions.checkNotNull(id, "id");
        this.account = account;
        this.cpuCount = cpuCount;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed;
        this.displayName = displayName;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.group = group;
        this.groupId = groupId;
        this.guestOSId = guestOSId;
        this.HAEnabled = HAEnabled;
        this.hostId = hostId;
        this.hostname = hostname;
        this.IPAddress = IPAddress2;
        this.ISODisplayText = ISODisplayText;
        this.ISOId = ISOId;
        this.ISOName = ISOName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.memory = memory;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.password = password;
        this.passwordEnabled = passwordEnabled;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.rootDeviceId = rootDeviceId;
        this.rootDeviceType = rootDeviceType;
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.state = state;
        this.templateDisplayText = templateDisplayText;
        this.templateId = templateId;
        this.templateName = templateName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.nics = nics == null ? ImmutableSet.of() : ImmutableSet.copyOf(nics);
        this.hypervisor = hypervisor;
        this.securityGroups = securityGroups == null ? ImmutableSet.of() : ImmutableSet.copyOf(securityGroups);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    public long getCpuCount() {
        return this.cpuCount;
    }

    public long getCpuSpeed() {
        return this.cpuSpeed;
    }

    public float getCpuUsed() {
        return this.cpuUsed != null ? Float.parseFloat(this.cpuUsed.substring(0, this.cpuUsed.length() - 1)) : 0.0f;
    }

    private String getCpuUsedAsString() {
        return this.cpuUsed;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getGuestOSId() {
        return this.guestOSId;
    }

    public boolean isHAEnabled() {
        return this.HAEnabled;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    @Nullable
    public String getISODisplayText() {
        return this.ISODisplayText;
    }

    @Nullable
    public String getISOId() {
        return this.ISOId;
    }

    @Nullable
    public String getISOName() {
        return this.ISOName;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public long getMemory() {
        return this.memory;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    @Nullable
    public Long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    @Nullable
    public String getPublicIP() {
        return this.publicIP;
    }

    @Nullable
    public String getPublicIPId() {
        return this.publicIPId;
    }

    @Nullable
    public String getRootDeviceId() {
        return this.rootDeviceId;
    }

    @Nullable
    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    @Nullable
    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    @Nullable
    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getTemplateDisplayText() {
        return this.templateDisplayText;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public Set<NIC> getNICs() {
        return this.nics;
    }

    @Nullable
    public String getHypervisor() {
        return this.hypervisor;
    }

    public Set<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor, this.securityGroups});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualMachine that = (VirtualMachine)VirtualMachine.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.account, that.account) && Objects.equal(this.cpuCount, that.cpuCount) && Objects.equal(this.cpuSpeed, that.cpuSpeed) && Objects.equal(this.cpuUsed, that.cpuUsed) && Objects.equal(this.displayName, that.displayName) && Objects.equal(this.created, that.created) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.usesVirtualNetwork, that.usesVirtualNetwork) && Objects.equal(this.group, that.group) && Objects.equal(this.groupId, that.groupId) && Objects.equal(this.guestOSId, that.guestOSId) && Objects.equal(this.HAEnabled, that.HAEnabled) && Objects.equal(this.hostId, that.hostId) && Objects.equal(this.hostname, that.hostname) && Objects.equal(this.IPAddress, that.IPAddress) && Objects.equal(this.ISODisplayText, that.ISODisplayText) && Objects.equal(this.ISOId, that.ISOId) && Objects.equal(this.ISOName, that.ISOName) && Objects.equal(this.jobId, that.jobId) && Objects.equal(this.jobStatus, that.jobStatus) && Objects.equal(this.memory, that.memory) && Objects.equal(this.name, that.name) && Objects.equal(this.networkKbsRead, that.networkKbsRead) && Objects.equal(this.networkKbsWrite, that.networkKbsWrite) && Objects.equal(this.password, that.password) && Objects.equal(this.passwordEnabled, that.passwordEnabled) && Objects.equal(this.publicIP, that.publicIP) && Objects.equal(this.publicIPId, that.publicIPId) && Objects.equal(this.rootDeviceId, that.rootDeviceId) && Objects.equal(this.rootDeviceType, that.rootDeviceType) && Objects.equal(this.serviceOfferingId, that.serviceOfferingId) && Objects.equal(this.serviceOfferingName, that.serviceOfferingName) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.templateDisplayText, that.templateDisplayText) && Objects.equal(this.templateId, that.templateId) && Objects.equal(this.templateName, that.templateName) && Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.zoneName, that.zoneName) && Objects.equal(this.nics, that.nics) && Objects.equal(this.hypervisor, that.hypervisor) && Objects.equal(this.securityGroups, that.securityGroups);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("account", this.account).add("cpuCount", this.cpuCount).add("cpuSpeed", this.cpuSpeed).add("cpuUsed", this.cpuUsed).add("displayName", this.displayName).add("created", this.created).add("domain", this.domain).add("domainId", this.domainId).add("usesVirtualNetwork", this.usesVirtualNetwork).add("group", this.group).add("groupId", this.groupId).add("guestOSId", this.guestOSId).add("HAEnabled", this.HAEnabled).add("hostId", this.hostId).add("hostname", this.hostname).add("IPAddress", this.IPAddress).add("ISODisplayText", this.ISODisplayText).add("ISOId", this.ISOId).add("ISOName", this.ISOName).add("jobId", this.jobId).add("jobStatus", this.jobStatus).add("memory", this.memory).add("name", this.name).add("networkKbsRead", this.networkKbsRead).add("networkKbsWrite", this.networkKbsWrite).add("password", this.password).add("passwordEnabled", this.passwordEnabled).add("publicIP", this.publicIP).add("publicIPId", this.publicIPId).add("rootDeviceId", this.rootDeviceId).add("rootDeviceType", this.rootDeviceType).add("serviceOfferingId", this.serviceOfferingId).add("serviceOfferingName", this.serviceOfferingName).add("state", (Object)this.state).add("templateDisplayText", this.templateDisplayText).add("templateId", this.templateId).add("templateName", this.templateName).add("zoneId", this.zoneId).add("zoneName", this.zoneName).add("nics", this.nics).add("hypervisor", this.hypervisor).add("securityGroups", this.securityGroups);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected long cpuCount;
        protected long cpuSpeed;
        protected String cpuUsed;
        protected String displayName;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected boolean usesVirtualNetwork;
        protected String group;
        protected String groupId;
        protected String guestOSId;
        protected boolean HAEnabled;
        protected String hostId;
        protected String hostname;
        protected String IPAddress;
        protected String ISODisplayText;
        protected String ISOId;
        protected String ISOName;
        protected String jobId;
        protected Integer jobStatus;
        protected long memory;
        protected String name;
        protected Long networkKbsRead;
        protected Long networkKbsWrite;
        protected String password;
        protected boolean passwordEnabled;
        protected String publicIP;
        protected String publicIPId;
        protected String rootDeviceId;
        protected String rootDeviceType;
        protected String serviceOfferingId;
        protected String serviceOfferingName;
        protected State state;
        protected String templateDisplayText;
        protected String templateId;
        protected String templateName;
        protected String zoneId;
        protected String zoneName;
        protected Set<NIC> nics = ImmutableSet.of();
        protected String hypervisor;
        protected Set<SecurityGroup> securityGroups = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T cpuCount(long cpuCount) {
            this.cpuCount = cpuCount;
            return this.self();
        }

        public T cpuSpeed(long cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this.self();
        }

        public T cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this.self();
        }

        public T displayName(String displayName) {
            this.displayName = displayName;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this.self();
        }

        public T group(String group) {
            this.group = group;
            return this.self();
        }

        public T groupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public T guestOSId(String guestOSId) {
            this.guestOSId = guestOSId;
            return this.self();
        }

        public T isHAEnabled(boolean HAEnabled) {
            this.HAEnabled = HAEnabled;
            return this.self();
        }

        public T hostId(String hostId) {
            this.hostId = hostId;
            return this.self();
        }

        public T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T IPAddress(String IPAddress2) {
            this.IPAddress = IPAddress2;
            return this.self();
        }

        public T ISODisplayText(String ISODisplayText) {
            this.ISODisplayText = ISODisplayText;
            return this.self();
        }

        public T ISOId(String ISOId) {
            this.ISOId = ISOId;
            return this.self();
        }

        public T ISOName(String ISOName) {
            this.ISOName = ISOName;
            return this.self();
        }

        public T jobId(String jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public T jobStatus(Integer jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public T memory(long memory) {
            this.memory = memory;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T networkKbsRead(Long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this.self();
        }

        public T networkKbsWrite(Long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public T passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this.self();
        }

        public T publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this.self();
        }

        public T publicIPId(String publicIPId) {
            this.publicIPId = publicIPId;
            return this.self();
        }

        public T rootDeviceId(String rootDeviceId) {
            this.rootDeviceId = rootDeviceId;
            return this.self();
        }

        public T rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this.self();
        }

        public T serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this.self();
        }

        public T serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T templateDisplayText(String templateDisplayText) {
            this.templateDisplayText = templateDisplayText;
            return this.self();
        }

        public T templateId(String templateId) {
            this.templateId = templateId;
            return this.self();
        }

        public T templateName(String templateName) {
            this.templateName = templateName;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public T nics(Set<NIC> nics) {
            this.nics = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(nics, "nics"));
            return this.self();
        }

        public T nics(NIC ... in) {
            return this.nics(ImmutableSet.copyOf(in));
        }

        public T hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this.self();
        }

        public T securityGroups(Set<SecurityGroup> securityGroups) {
            this.securityGroups = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(securityGroups, "securityGroups"));
            return this.self();
        }

        public T securityGroups(SecurityGroup ... in) {
            return this.securityGroups(ImmutableSet.copyOf(in));
        }

        public VirtualMachine build() {
            return new VirtualMachine(this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor, this.securityGroups);
        }

        public T fromVirtualMachine(VirtualMachine in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).cpuCount(in.getCpuCount())).cpuSpeed(in.getCpuSpeed())).cpuUsed(in.getCpuUsedAsString())).displayName(in.getDisplayName())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).usesVirtualNetwork(in.usesVirtualNetwork())).group(in.getGroup())).groupId(in.getGroupId())).guestOSId(in.getGuestOSId())).isHAEnabled(in.isHAEnabled())).hostId(in.getHostId())).hostname(in.getHostname())).IPAddress(in.getIPAddress())).ISODisplayText(in.getISODisplayText())).ISOId(in.getISOId())).ISOName(in.getISOName())).jobId(in.getJobId())).jobStatus(in.getJobStatus())).memory(in.getMemory())).name(in.getName())).networkKbsRead(in.getNetworkKbsRead())).networkKbsWrite(in.getNetworkKbsWrite())).password(in.getPassword())).passwordEnabled(in.isPasswordEnabled())).publicIP(in.getPublicIP())).publicIPId(in.getPublicIPId())).rootDeviceId(in.getRootDeviceId())).rootDeviceType(in.getRootDeviceType())).serviceOfferingId(in.getServiceOfferingId())).serviceOfferingName(in.getServiceOfferingName())).state(in.getState())).templateDisplayText(in.getTemplateDisplayText())).templateId(in.getTemplateId())).templateName(in.getTemplateName())).zoneId(in.getZoneId())).zoneName(in.getZoneName())).nics(in.getNICs())).hypervisor(in.getHypervisor())).securityGroups(in.getSecurityGroups());
        }
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        DESTROYED,
        EXPUNGING,
        MIGRATING,
        ERROR,
        UNKNOWN,
        SHUTDOWNED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(state, "state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

