/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import org.jclouds.cloudsigma.domain.MediaType;

public abstract class Device {
    protected final String driveUuid;
    protected final MediaType mediaType;

    public Device(String driveUuid, MediaType mediaType) {
        this.driveUuid = Preconditions.checkNotNull(driveUuid, "driveUuid");
        this.mediaType = Preconditions.checkNotNull(mediaType, "mediaType");
    }

    public abstract String getId();

    public String getDriveUuid() {
        return this.driveUuid;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driveUuid == null ? 0 : this.driveUuid.hashCode());
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (this.driveUuid == null ? other.driveUuid != null : !this.driveUuid.equals(other.driveUuid)) {
            return false;
        }
        return this.mediaType == other.mediaType;
    }

    public String toString() {
        return "[driveUuid=" + this.driveUuid + ", mediaType=" + (Object)((Object)this.mediaType) + "]";
    }

    public static abstract class Builder {
        protected String uuid;
        protected MediaType mediaType = MediaType.DISK;

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public abstract Device build();
    }
}

