/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.base.Preconditions;
import org.jclouds.blobstore.options.ListContainerOptions;

public class ListOptions
implements Cloneable {
    public static final ImmutableListOptions NONE = new ImmutableListOptions(new ListOptions());
    private Integer maxKeys;
    private String marker;

    ListOptions(Integer maxKeys, String marker) {
        this.maxKeys = maxKeys;
        this.marker = marker;
    }

    public ListOptions() {
    }

    public Integer getMaxResults() {
        return this.maxKeys;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListOptions afterMarker(String marker) {
        this.marker = Preconditions.checkNotNull(marker, "marker");
        return this;
    }

    public ListOptions maxResults(int maxKeys) {
        Preconditions.checkArgument(maxKeys >= 0, "maxKeys must be >= 0");
        this.maxKeys = maxKeys;
        return this;
    }

    protected ListOptions clone() {
        return new ListOptions(this.maxKeys, this.marker);
    }

    public static class Builder {
        public static ListOptions afterMarker(String marker) {
            ListOptions options = new ListOptions();
            return options.afterMarker(marker);
        }

        public static ListOptions maxResults(int maxKeys) {
            ListOptions options = new ListOptions();
            return options.maxResults(maxKeys);
        }
    }

    public static class ImmutableListOptions
    extends ListOptions {
        private final ListOptions delegate;

        @Override
        public ListContainerOptions afterMarker(String marker) {
            throw new UnsupportedOperationException();
        }

        public ImmutableListOptions(ListOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public ListContainerOptions maxResults(int maxKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMarker() {
            return this.delegate.getMarker();
        }

        @Override
        public Integer getMaxResults() {
            return this.delegate.getMaxResults();
        }

        @Override
        public ListOptions clone() {
            return this.delegate.clone();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

