/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TasksList;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.functions.OrgNameToTasksListEndpoint;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.TasksListHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface TaskAsyncClient {
    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.tasksList+xml"})
    @XMLResponseParser(value=TasksListHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<TasksList> getTasksList(@EndpointParam URI var1);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.tasksList+xml"})
    @XMLResponseParser(value=TasksListHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<TasksList> findTasksListInOrgNamed(@Nullable @EndpointParam(parser=OrgNameToTasksListEndpoint.class) String var1);

    @GET
    @Consumes(value={"application/vnd.vmware.vcloud.task+xml"})
    @XMLResponseParser(value=TaskHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Task> getTask(@EndpointParam URI var1);

    @POST
    @Path(value="/action/cancel")
    public ListenableFuture<Void> cancelTask(@EndpointParam URI var1);
}

