/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class IpRange {
    private final String startAddress;
    private final String endAddress;

    public IpRange(String startAddress, String endAddress) {
        this.startAddress = Preconditions.checkNotNull(startAddress, "startAddress");
        this.endAddress = Preconditions.checkNotNull(endAddress, "endAddress");
    }

    public String getStartAddress() {
        return this.startAddress;
    }

    public String getEndAddress() {
        return this.endAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpRange that = (IpRange)IpRange.class.cast(o);
        return Objects.equal(this.startAddress, that.startAddress) && Objects.equal(this.endAddress, that.endAddress);
    }

    public int hashCode() {
        return Objects.hashCode(this.startAddress, this.endAddress);
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("startAddress", this.startAddress).add("endAddress", this.endAddress).toString();
    }
}

